/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.reflect;

import javax.annotation.Nonnull;
import me.lucko.helper.reflect.NmsVersion;
import org.bukkit.Bukkit;

public final class ServerReflection {
    public static final String NMS = "net.minecraft.server";
    public static final String OBC = "org.bukkit.craftbukkit";
    private static final String SERVER_VERSION;
    private static final NmsVersion NMS_VERSION;

    @Nonnull
    public static String getServerVersion() {
        return SERVER_VERSION;
    }

    @Nonnull
    public static NmsVersion getNmsVersion() {
        return NMS_VERSION;
    }

    @Nonnull
    public static String nms(String className) {
        return NMS_VERSION.nms(className);
    }

    @Nonnull
    public static Class<?> nmsClass(String className) throws ClassNotFoundException {
        return NMS_VERSION.nmsClass(className);
    }

    @Nonnull
    public static String obc(String className) {
        return NMS_VERSION.obc(className);
    }

    @Nonnull
    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return NMS_VERSION.obcClass(className);
    }

    private ServerReflection() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    static {
        String obcPackage;
        String serverVersion = "";
        Class<?> server = Bukkit.getServer().getClass();
        if (server.getSimpleName().equals("CraftServer") && !server.getName().equals("org.bukkit.craftbukkit.CraftServer") && (obcPackage = server.getPackage().getName()).startsWith("org.bukkit.craftbukkit.")) {
            serverVersion = obcPackage.substring("org.bukkit.craftbukkit.".length());
        }
        NMS_VERSION = (SERVER_VERSION = serverVersion).isEmpty() ? NmsVersion.NONE : NmsVersion.valueOf(serverVersion);
    }
}

