/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text.adapter.bukkit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.adapter.bukkit.Adapter;
import me.lucko.helper.text.adapter.bukkit.CraftBukkitAdapter;
import me.lucko.helper.text.adapter.bukkit.LegacyAdapter;
import me.lucko.helper.text.adapter.bukkit.SpigotAdapter;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

final class TextAdapter0 {
    private static final List<Adapter> ADAPTERS = TextAdapter0.pickAdapters();

    TextAdapter0() {
    }

    private static List<Adapter> pickAdapters() {
        ImmutableList.Builder adapters = ImmutableList.builder();
        if (TextAdapter0.isSpigotAdapterSupported()) {
            adapters.add((Object)new SpigotAdapter());
        }
        adapters.add((Object)new CraftBukkitAdapter());
        adapters.add((Object)new LegacyAdapter());
        return adapters.build();
    }

    private static boolean isSpigotAdapterSupported() {
        try {
            Player.class.getMethod("spigot", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static void sendComponent(Iterable<? extends CommandSender> viewers, Component component) {
        ArrayList list = new ArrayList();
        Iterables.addAll(list, viewers);
        Iterator<Adapter> it = ADAPTERS.iterator();
        while (it.hasNext() && !list.isEmpty()) {
            Adapter adapter = it.next();
            adapter.sendComponent(list, component);
        }
    }
}

