/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class NullableOptional<T> {
    private static final NullableOptional<?> EMPTY = new NullableOptional();
    private final T value;
    private final boolean isPresent;

    @Nonnull
    public static <T> NullableOptional<T> empty() {
        NullableOptional<?> t = EMPTY;
        return t;
    }

    @Nonnull
    public static <T> NullableOptional<T> of(@Nullable T value) {
        return new NullableOptional<T>(value);
    }

    @Nonnull
    public static <T> NullableOptional<T> fromOptional(@Nonnull Optional<T> value) {
        return value.isPresent() ? NullableOptional.of(value.get()) : NullableOptional.empty();
    }

    private NullableOptional() {
        this.value = null;
        this.isPresent = false;
    }

    private NullableOptional(@Nullable T value) {
        this.value = value;
        this.isPresent = true;
    }

    @Nullable
    public T get() {
        if (!this.isPresent()) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    @Nonnull
    public Optional<T> asOptional() {
        return this.isPresent() ? Optional.ofNullable(this.value) : Optional.empty();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(@Nonnull Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    @Nonnull
    public NullableOptional<T> filter(@Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : NullableOptional.empty();
    }

    @Nonnull
    public <U> NullableOptional<U> map(@Nonnull Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return NullableOptional.empty();
        }
        return NullableOptional.of(mapper.apply(this.value));
    }

    @Nonnull
    public <U> NullableOptional<U> flatMap(@Nonnull Function<? super T, NullableOptional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return NullableOptional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    @Nullable
    public T orElse(@Nullable T other) {
        return this.isPresent() ? this.value : other;
    }

    @Nullable
    public T orElseGet(@Nonnull Supplier<? extends T> other) {
        return this.isPresent() ? this.value : other.get();
    }

    @Nullable
    public <X extends Throwable> T orElseThrow(@Nonnull Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NullableOptional)) {
            return false;
        }
        NullableOptional other = (NullableOptional)obj;
        return this.isPresent == other.isPresent && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        if (!this.isPresent) {
            return -1;
        }
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.isPresent() ? String.format("NullableOptional[%s]", this.value) : "NullableOptional.empty";
    }
}

