/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils.entityspawner;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import me.lucko.helper.reflect.ServerReflection;
import me.lucko.helper.utils.entityspawner.EntitySpawner;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;

enum EntitySpawnerLegacy implements EntitySpawner
{
    INSTANCE;

    private static final Method CREATE_ENTITY_METHOD;
    private static final Method ADD_ENTITY_METHOD;
    private static final Method GET_BUKKIT_ENTITY_METHOD;

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> entityClass, Consumer<? super T> beforeAdd) {
        World world = location.getWorld();
        try {
            Object entity = CREATE_ENTITY_METHOD.invoke((Object)world, location, entityClass);
            Entity bukkitEntity = (Entity)entityClass.cast(GET_BUKKIT_ENTITY_METHOD.invoke(entity, new Object[0]));
            beforeAdd.accept(bukkitEntity);
            ADD_ENTITY_METHOD.invoke((Object)world, entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return (T)bukkitEntity;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> craftWorldClass = ServerReflection.obcClass("CraftWorld");
            Class<?> entityClass = ServerReflection.nmsClass("Entity");
            CREATE_ENTITY_METHOD = craftWorldClass.getDeclaredMethod("createEntity", Location.class, Class.class);
            ADD_ENTITY_METHOD = craftWorldClass.getDeclaredMethod("addEntity", entityClass, CreatureSpawnEvent.SpawnReason.class);
            GET_BUKKIT_ENTITY_METHOD = entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

