/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import me.lucko.shadow.ClassTarget;
import me.lucko.shadow.DynamicClassTarget;
import me.lucko.shadow.DynamicFieldTarget;
import me.lucko.shadow.DynamicMethodTarget;
import me.lucko.shadow.FuzzyFieldTargetResolver;
import me.lucko.shadow.Shadow;
import me.lucko.shadow.Target;
import me.lucko.shadow.TargetResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

final class TargetLookup
implements TargetResolver {
    private final @NonNull List<TargetResolver> resolvers = new CopyOnWriteArrayList<TargetResolver>(Arrays.asList(ClassTarget.RESOLVER, Target.RESOLVER, DynamicClassTarget.RESOLVER, DynamicMethodTarget.RESOLVER, DynamicFieldTarget.RESOLVER, FuzzyFieldTargetResolver.INSTANCE));

    TargetLookup() {
    }

    public void registerResolver(@NonNull TargetResolver targetResolver) {
        Objects.requireNonNull(targetResolver, "targetResolver");
        if (!this.resolvers.contains(targetResolver)) {
            this.resolvers.add(0, targetResolver);
        }
    }

    @Override
    public @NonNull Optional<Class<?>> lookupClass(@NonNull Class<? extends Shadow> shadowClass) throws ClassNotFoundException {
        for (TargetResolver resolver : this.resolvers) {
            Optional<Class<?>> result = resolver.lookupClass(shadowClass);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Optional<String> lookupMethod(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
        for (TargetResolver resolver : this.resolvers) {
            Optional<String> result = resolver.lookupMethod(shadowMethod, shadowClass, targetClass);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Optional<String> lookupField(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
        for (TargetResolver resolver : this.resolvers) {
            Optional<String> result = resolver.lookupField(shadowMethod, shadowClass, targetClass);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

