/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.loader;

import com.google.common.collect.Collections2;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import me.lucko.helper.config.loader.CommentHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum CommentHandlers implements CommentHandler
{
    HASH(new AbstractPrefixHandler("#")),
    DOUBLE_SLASH(new AbstractPrefixHandler("//")),
    SLASH_BLOCK(new AbstractDelineatedHandler("/*", "*/", "*")),
    XML_STYLE(new AbstractDelineatedHandler("<!--", "-->", "~"));

    private static final int READAHEAD_LEN = 4096;
    private final CommentHandler delegate;

    private CommentHandlers(CommentHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public @NonNull Optional<String> extractHeader(@NonNull BufferedReader reader) throws IOException {
        return this.delegate.extractHeader(reader);
    }

    @Override
    public @NonNull Collection<String> toComment(@NonNull Collection<String> lines) {
        return this.delegate.toComment(lines);
    }

    public static @Nullable String extractComment(@NonNull BufferedReader reader, CommentHandler ... allowedHeaderTypes) throws IOException {
        reader.mark(4096);
        for (CommentHandler handler : allowedHeaderTypes) {
            Optional<String> comment = handler.extractHeader(reader);
            if (comment.isPresent()) {
                return comment.get();
            }
            reader.reset();
        }
        return null;
    }

    static boolean beginsWithPrefix(String commentPrefix, BufferedReader reader) throws IOException {
        CharBuffer buf = CharBuffer.allocate(commentPrefix.length());
        if (reader.read(buf) != buf.limit()) {
            return false;
        }
        buf.flip();
        return commentPrefix.contentEquals(buf);
    }

    private static final class AbstractPrefixHandler
    implements CommentHandler {
        private final String commentPrefix;

        AbstractPrefixHandler(String commentPrefix) {
            this.commentPrefix = commentPrefix;
        }

        @Override
        public @NonNull Optional<String> extractHeader(@NonNull BufferedReader reader) throws IOException {
            if (!CommentHandlers.beginsWithPrefix(this.commentPrefix, reader)) {
                return Optional.empty();
            }
            boolean firstLine = true;
            StringBuilder build = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if (firstLine || line.trim().startsWith(this.commentPrefix)) {
                    line = firstLine ? line : line.substring(line.indexOf(this.commentPrefix) + 1);
                    firstLine = false;
                    if (line.startsWith(" ")) {
                        line = line.substring(1);
                    }
                    if (build.length() > 0) {
                        build.append("\n");
                    }
                } else {
                    if (line.trim().isEmpty()) break;
                    return Optional.empty();
                }
                build.append(line);
                line = reader.readLine();
            }
            return build.length() > 0 ? Optional.of(build.toString()) : Optional.empty();
        }

        @Override
        public @NonNull Collection<String> toComment(@NonNull Collection<String> lines) {
            return Collections2.transform(lines, s -> {
                if (s.startsWith(" ")) {
                    return this.commentPrefix + s;
                }
                return this.commentPrefix + " " + s;
            });
        }
    }

    private static final class AbstractDelineatedHandler
    implements CommentHandler {
        private final String startSequence;
        private final String endSequence;
        private final String lineIndentSequence;

        private AbstractDelineatedHandler(String startSequence, String endSequence, String lineIndentSequence) {
            this.startSequence = startSequence;
            this.endSequence = endSequence;
            this.lineIndentSequence = lineIndentSequence;
        }

        @Override
        public @NonNull Optional<String> extractHeader(@NonNull BufferedReader reader) throws IOException {
            if (!CommentHandlers.beginsWithPrefix(this.startSequence, reader)) {
                return Optional.empty();
            }
            StringBuilder build = new StringBuilder();
            String line = reader.readLine();
            if (line == null) {
                return Optional.empty();
            }
            if (this.handleSingleLine(build, line)) {
                line = reader.readLine();
                while (line != null && this.handleSingleLine(build, line)) {
                    line = reader.readLine();
                }
            }
            if ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
                return Optional.empty();
            }
            if (build.length() > 0) {
                return Optional.of(build.toString());
            }
            return Optional.empty();
        }

        private boolean handleSingleLine(StringBuilder builder, String line) {
            boolean moreLines = true;
            if (line.trim().endsWith(this.endSequence)) {
                if ((line = line.substring(0, line.lastIndexOf(this.endSequence))).endsWith(" ")) {
                    line = line.substring(0, line.length() - 1);
                }
                moreLines = false;
                if (line.isEmpty()) {
                    return false;
                }
            }
            if (line.trim().startsWith(this.lineIndentSequence)) {
                line = line.substring(line.indexOf(this.lineIndentSequence) + 1);
            }
            if (line.startsWith(" ")) {
                line = line.substring(1);
            }
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line.replace("\r", "").replace("\n", "").replace("\r\n", ""));
            return moreLines;
        }

        @Override
        public @NonNull Collection<String> toComment(@NonNull Collection<String> lines) {
            if (lines.size() == 1) {
                return lines.stream().map(i -> this.startSequence + " " + i + " " + this.endSequence).collect(Collectors.toList());
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(this.startSequence);
            ret.addAll(lines.stream().map(i -> " " + this.lineIndentSequence + " " + i).collect(Collectors.toList()));
            ret.add(" " + this.endSequence);
            return ret;
        }
    }
}

