/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class CharSerializer
implements TypeSerializer<Character> {
    CharSerializer() {
    }

    @Override
    public @Nullable Character deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (value.isList() || value.isMap()) {
            return null;
        }
        Object val = value.getValue();
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 1) {
                return Character.valueOf(strVal.charAt(0));
            }
        } else {
            if (val instanceof Character) {
                return (Character)val;
            }
            if (val instanceof Number) {
                return Character.valueOf((char)((Number)val).shortValue());
            }
        }
        return null;
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable Character obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (value.getOptions().acceptsType(Character.TYPE)) {
            value.setValue(obj);
        } else {
            value.setValue(obj == null ? null : obj.toString());
        }
    }
}

