/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.AbstractListChildSerializer;
import me.lucko.helper.config.util.CheckedConsumer;

class ListSerializer
extends AbstractListChildSerializer<List<?>> {
    ListSerializer() {
    }

    @Override
    TypeToken<?> getElementType(TypeToken<?> containerType) throws ObjectMappingException {
        if (!(containerType.getType() instanceof ParameterizedType)) {
            throw new ObjectMappingException("Raw types are not supported for collections");
        }
        return containerType.resolveType(List.class.getTypeParameters()[0]);
    }

    @Override
    List<?> createNew(int length, TypeToken<?> elementType) {
        return new ArrayList(length);
    }

    @Override
    void forEachElement(List<?> collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    void deserializeSingle(int index, List<?> collection, Object deserialized) {
        collection.add(deserialized);
    }
}

