/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.datatree;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import me.lucko.helper.datatree.DataTree;

public class GsonDataTree
implements DataTree {
    private final JsonElement element;

    public GsonDataTree(JsonElement element) {
        this.element = Objects.requireNonNull(element, "element");
    }

    public JsonElement getElement() {
        return this.element;
    }

    @Override
    @Nonnull
    public GsonDataTree resolve(Object ... path) {
        if (path.length == 0) {
            return this;
        }
        JsonElement o = this.element;
        for (int i = 0; i < path.length; ++i) {
            Object p = path[i];
            if (p instanceof String) {
                String memberName = (String)p;
                JsonObject obj = o.getAsJsonObject();
                if (!obj.has(memberName)) {
                    throw new IllegalArgumentException("Object " + obj + " does not have member: " + memberName);
                }
                o = obj.get(memberName);
                continue;
            }
            if (p instanceof Number) {
                o = o.getAsJsonArray().get(((Number)p).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown path node at index " + i + ": " + p);
        }
        return new GsonDataTree(o);
    }

    @Nonnull
    public Stream<Map.Entry<String, GsonDataTree>> asObject() {
        return this.element.getAsJsonObject().entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)new GsonDataTree((JsonElement)entry.getValue())));
    }

    @Nonnull
    public Stream<GsonDataTree> asArray() {
        return StreamSupport.stream(this.element.getAsJsonArray().spliterator(), false).map(GsonDataTree::new);
    }

    @Nonnull
    public Stream<Map.Entry<Integer, GsonDataTree>> asIndexedArray() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Map.Entry<Integer, GsonDataTree>>(){
            private final Iterator<JsonElement> iterator;
            private int index;
            {
                this.iterator = GsonDataTree.this.element.getAsJsonArray().iterator();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<Integer, GsonDataTree> next() {
                return Maps.immutableEntry((Object)this.index++, (Object)new GsonDataTree(this.iterator.next()));
            }
        }, 1040), false);
    }

    @Override
    @Nonnull
    public String asString() {
        return this.element.getAsString();
    }

    @Override
    @Nonnull
    public Number asNumber() {
        return this.element.getAsNumber();
    }

    @Override
    public int asInt() {
        return this.element.getAsInt();
    }

    @Override
    public double asDouble() {
        return this.element.getAsDouble();
    }

    @Override
    public boolean asBoolean() {
        return this.element.getAsBoolean();
    }
}

