/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.function.chain;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.lucko.helper.function.chain.Chain;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
class SimpleChain<T>
implements Chain<T> {
    @Nullable
    private T object;

    SimpleChain(@Nullable T object) {
        this.object = object;
    }

    @Override
    public Chain<T> apply(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action");
        action.accept(this.object);
        return this;
    }

    @Override
    public Chain<T> applyIf(Predicate<? super T> test, Consumer<? super T> action) {
        Objects.requireNonNull(test, "test");
        Objects.requireNonNull(action, "action");
        if (test.test(this.object)) {
            action.accept(this.object);
        }
        return this;
    }

    @Override
    public Chain<T> applyIfNonNull(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action");
        if (this.object != null) {
            action.accept(this.object);
        }
        return this;
    }

    @Override
    public Chain<T> orElse(Predicate<? super T> test, T failValue) {
        Objects.requireNonNull(test, "test");
        if (!test.test(this.object)) {
            this.object = failValue;
        }
        return this;
    }

    @Override
    public Chain<T> orElseIfNull(T otherValue) {
        if (this.object == null) {
            this.object = otherValue;
        }
        return this;
    }

    @Override
    public Chain<T> orElseGet(Predicate<? super T> test, Supplier<? extends T> failSupplier) {
        Objects.requireNonNull(test, "test");
        Objects.requireNonNull(failSupplier, "failSupplier");
        if (!test.test(this.object)) {
            this.object = failSupplier.get();
        }
        return this;
    }

    @Override
    public Chain<T> orElseGetIfNull(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        if (this.object == null) {
            this.object = supplier.get();
        }
        return this;
    }

    @Override
    public <R> Chain<R> ifElse(Predicate<? super T> test, R passValue, R failValue) {
        Objects.requireNonNull(test, "test");
        return test.test(this.object) ? this.map(s -> passValue) : this.map(s -> failValue);
    }

    @Override
    public <R> Chain<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        R result = mapper.apply(this.object);
        if (result == this.object) {
            return this;
        }
        return new SimpleChain<R>(result);
    }

    @Override
    public <R> Chain<R> mapOrElse(Predicate<? super T> test, Function<? super T, ? extends R> passedMapper, R otherValue) {
        Objects.requireNonNull(test, "test");
        Objects.requireNonNull(passedMapper, "passedMapper");
        return this.mapOrElse(test, passedMapper, s -> otherValue);
    }

    @Override
    public <R> Chain<R> mapOrElse(Predicate<? super T> test, Function<? super T, ? extends R> passedMapper, Function<? super T, ? extends R> failedMapper) {
        Objects.requireNonNull(test, "test");
        Objects.requireNonNull(passedMapper, "passedMapper");
        Objects.requireNonNull(failedMapper, "failedMapper");
        return test.test(this.object) ? this.map(passedMapper) : this.map(failedMapper);
    }

    @Override
    public <R> Chain<R> mapNullSafe(Function<? super T, ? extends R> nonNullMapper, R otherValue) {
        Objects.requireNonNull(nonNullMapper, "nonNullMapper");
        return this.mapNullSafeGet(nonNullMapper, () -> otherValue);
    }

    @Override
    public <R> Chain<R> mapNullSafeGet(Function<? super T, ? extends R> nonNullMapper, Supplier<? extends R> nullSupplier) {
        R result;
        Objects.requireNonNull(nonNullMapper, "nonNullMapper");
        Objects.requireNonNull(nullSupplier, "nullSupplier");
        R r = result = this.object != null ? nonNullMapper.apply(this.object) : nullSupplier.get();
        if (result == this.object) {
            return this;
        }
        return new SimpleChain<R>(result);
    }

    @Override
    public <R> Chain<R> flatMap(Function<? super T, ? extends Chain<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return mapper.apply(this.object);
    }

    @Override
    public Optional<T> end() {
        return Optional.ofNullable(this.object);
    }

    @Override
    @Nullable
    public T endOrNull() {
        return this.object;
    }
}

