/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging.codec;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import me.lucko.helper.gson.GsonProvider;
import me.lucko.helper.messaging.codec.Codec;
import me.lucko.helper.messaging.codec.EncodingException;

public class GsonCodec<M>
implements Codec<M> {
    private final Gson gson;
    private final TypeToken<M> type;

    public GsonCodec(Gson gson, TypeToken<M> type) {
        this.gson = gson;
        this.type = type;
    }

    public GsonCodec(TypeToken<M> type) {
        this(GsonProvider.standard(), type);
    }

    @Override
    public byte[] encode(M message) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteOut, StandardCharsets.UTF_8);){
            this.gson.toJson(message, this.type.getType(), (Appendable)writer);
        }
        catch (IOException e) {
            throw new EncodingException(e);
        }
        return byteOut.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public M decode(byte[] buf) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(buf);
        try (InputStreamReader reader = new InputStreamReader((InputStream)byteIn, StandardCharsets.UTF_8);){
            Object object = this.gson.fromJson((Reader)reader, this.type.getType());
            return (M)object;
        }
        catch (IOException e) {
            throw new EncodingException(e);
        }
    }
}

