/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging.conversation;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import me.lucko.helper.messaging.conversation.ConversationMessage;
import me.lucko.helper.promise.Promise;

public final class ConversationReply<R extends ConversationMessage> {
    private static final ConversationReply<?> NO_REPLY = new ConversationReply(null);
    private final Promise<R> reply;

    public static <R extends ConversationMessage> ConversationReply<R> noReply() {
        return NO_REPLY;
    }

    public static <R extends ConversationMessage> ConversationReply<R> of(R reply) {
        Objects.requireNonNull(reply, "reply");
        return new ConversationReply<R>(Promise.completed(reply));
    }

    public static <R extends ConversationMessage> ConversationReply<R> ofCompletableFuture(CompletableFuture<R> futureReply) {
        Objects.requireNonNull(futureReply, "futureReply");
        return new ConversationReply<R>(Promise.wrapFuture(futureReply));
    }

    public static <R extends ConversationMessage> ConversationReply<R> ofPromise(Promise<R> promiseReply) {
        Objects.requireNonNull(promiseReply, "promiseReply");
        return new ConversationReply<R>(promiseReply);
    }

    private ConversationReply(Promise<R> reply) {
        this.reply = reply;
    }

    public boolean hasReply() {
        return this.reply != null;
    }

    @Nonnull
    public Promise<R> getReply() {
        if (this.reply == null) {
            throw new IllegalStateException("No reply present");
        }
        return this.reply;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConversationReply)) {
            return false;
        }
        ConversationReply other = (ConversationReply)obj;
        return Objects.equals(this.reply, other.reply);
    }

    public int hashCode() {
        return Objects.hashCode(this.reply);
    }

    public String toString() {
        return this.reply != null ? String.format("ConversationReply[%s]", this.reply) : "ConversationReply.noReply";
    }
}

