/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.metadata;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.lucko.helper.metadata.TransientValue;

public final class ExpiringValue<T>
implements TransientValue<T> {
    private final T value;
    private final long expireAt;

    public static <T> ExpiringValue<T> of(T value, long duration, TimeUnit unit) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"duration must be >= 0");
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(unit, "unit");
        long millis = unit.toMillis(duration);
        return new ExpiringValue<T>(value, millis);
    }

    public static <T> Supplier<ExpiringValue<T>> supplied(Supplier<? extends T> supplier, long duration, TimeUnit unit) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"duration must be >= 0");
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(unit, "unit");
        long millis = unit.toMillis(duration);
        return () -> {
            Object value = supplier.get();
            Objects.requireNonNull(value, "value");
            return new ExpiringValue(value, millis);
        };
    }

    private ExpiringValue(T value, long millis) {
        this.value = value;
        this.expireAt = System.currentTimeMillis() + millis;
    }

    @Override
    @Nullable
    public T getOrNull() {
        return this.shouldExpire() ? null : (T)this.value;
    }

    @Override
    public boolean shouldExpire() {
        return System.currentTimeMillis() > this.expireAt;
    }
}

