/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network;

import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import me.lucko.helper.Services;
import me.lucko.helper.eventbus.EventBus;
import me.lucko.helper.messaging.InstanceData;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.network.AbstractNetwork;
import me.lucko.helper.network.Server;
import me.lucko.helper.network.event.NetworkEvent;
import me.lucko.helper.network.metadata.ServerMetadataProvider;
import me.lucko.helper.profiles.Profile;
import me.lucko.helper.terminable.Terminable;

public interface Network
extends Terminable {
    public static Network create(Messenger messenger, InstanceData instanceData) {
        return new AbstractNetwork(messenger, instanceData);
    }

    public static Network obtain(Supplier<Network> ifElse) {
        Network network = Services.get(Network.class).orElse(null);
        if (network == null) {
            network = ifElse.get();
            Services.provide(Network.class, network);
        }
        return network;
    }

    public Map<String, Server> getServers();

    public Map<UUID, Profile> getOnlinePlayers();

    public int getOverallPlayerCount();

    public void registerMetadataProvider(ServerMetadataProvider var1);

    public EventBus<NetworkEvent> getEventBus();

    @Override
    public void close();
}

