/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.UUID;
import me.lucko.helper.gson.GsonProvider;
import me.lucko.helper.messaging.InstanceData;
import me.lucko.helper.profiles.Profile;

public interface Server
extends InstanceData {
    public boolean isOnline();

    public long getLastPing();

    public Map<UUID, Profile> getOnlinePlayers();

    public int getMaxPlayers();

    public boolean isFull();

    public boolean isWhitelisted();

    public Map<String, JsonElement> getRawMetadata();

    default public <T> T getMetadata(String key, Class<T> type) {
        return this.getMetadata(key, TypeToken.of(type));
    }

    default public <T> T getMetadata(String key, TypeToken<T> type) {
        JsonElement data = this.getRawMetadata().get(key);
        if (data == null) {
            return null;
        }
        return (T)GsonProvider.standard().fromJson(data, type.getType());
    }
}

