/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.setting;

import java.util.BitSet;
import me.lucko.helper.setting.BooleanSetting;
import me.lucko.helper.setting.BooleanSettingMapFactory;
import me.lucko.helper.setting.SettingMapFactory;

public final class BooleanSettingMap<S extends BooleanSetting> {
    private final BooleanSettingMapFactory<S> factory;
    private final BitSet bits;

    BooleanSettingMap(BooleanSettingMapFactory<S> factory, BitSet bits) {
        this.factory = factory;
        this.bits = bits;
    }

    public boolean get(S setting) {
        return this.bits.get(setting.ordinal());
    }

    public boolean set(S setting, boolean state) {
        if (state == this.get(setting)) {
            return state;
        }
        if (state) {
            this.bits.set(setting.ordinal());
        } else {
            this.bits.clear(setting.ordinal());
        }
        return !state;
    }

    public boolean toggle(S setting) {
        this.bits.flip(setting.ordinal());
        return this.get(setting);
    }

    public boolean isDifferentFromDefault() {
        return this.factory.isDifferentFromDefault(this.bits);
    }

    public byte[] encode() {
        return this.bits.toByteArray();
    }

    public String encodeToString() {
        return SettingMapFactory.ENCODING.encode(this.encode());
    }

    public String toString() {
        return this.bits.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanSettingMap that = (BooleanSettingMap)o;
        return this.factory.equals(that.factory) && this.bits.equals(that.bits);
    }

    public int hashCode() {
        return this.bits.hashCode();
    }
}

