/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.setting;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.setting.Setting;
import me.lucko.helper.setting.SettingMapFactory;

public final class SettingMap<S extends Setting<V>, V extends Setting.State> {
    private final SettingMapFactory<S, V> factory;
    private final byte[] states;

    SettingMap(SettingMapFactory<S, V> factory, byte[] states) {
        this.factory = factory;
        this.states = states;
    }

    public V get(S setting) {
        int stateOrdinal = Byte.toUnsignedInt(this.states[setting.ordinal()]);
        return this.factory.states[stateOrdinal];
    }

    public V set(S setting, V state) {
        V prev = this.get(setting);
        if (state == prev) {
            return state;
        }
        this.states[setting.ordinal()] = (byte)state.ordinal();
        return prev;
    }

    public Map<S, V> exportToMap() {
        HashMap map = new HashMap();
        S[] settings = this.factory.settings;
        for (int i = 0; i < settings.length; ++i) {
            Object setting = settings[i];
            int stateOrdinal = Byte.toUnsignedInt(this.states[i]);
            map.put(setting, this.factory.states[stateOrdinal]);
        }
        return map;
    }

    public boolean isDifferentFromDefault() {
        return this.factory.isDifferentFromDefault(this.states);
    }

    public byte[] encode() {
        return this.factory.encode(this.states);
    }

    public String encodeToString() {
        return SettingMapFactory.ENCODING.encode(this.encode());
    }

    public String toString() {
        return this.exportToMap().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingMap that = (SettingMap)o;
        return this.factory.equals(that.factory) && Arrays.equals(this.states, that.states);
    }

    public int hashCode() {
        return Arrays.hashCode(this.states);
    }
}

