/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.terminable.composite;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.terminable.Terminable;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.composite.AbstractCompositeTerminable;
import me.lucko.helper.terminable.composite.AbstractWeakCompositeTerminable;
import me.lucko.helper.terminable.composite.CompositeClosingException;

public interface CompositeTerminable
extends Terminable,
TerminableConsumer {
    @Nonnull
    public static CompositeTerminable create() {
        return new AbstractCompositeTerminable();
    }

    @Nonnull
    public static CompositeTerminable createWeak() {
        return new AbstractWeakCompositeTerminable();
    }

    @Override
    public void close() throws CompositeClosingException;

    @Override
    @Nullable
    default public CompositeClosingException closeSilently() {
        try {
            this.close();
            return null;
        }
        catch (CompositeClosingException e) {
            return e;
        }
    }

    @Override
    default public void closeAndReportException() {
        try {
            this.close();
        }
        catch (CompositeClosingException e) {
            e.printAllStackTraces();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompositeTerminable with(AutoCloseable var1);

    default public CompositeTerminable withAll(AutoCloseable ... autoCloseables) {
        for (AutoCloseable autoCloseable : autoCloseables) {
            if (autoCloseable == null) continue;
            this.bind(autoCloseable);
        }
        return this;
    }

    default public CompositeTerminable withAll(Iterable<? extends AutoCloseable> autoCloseables) {
        for (AutoCloseable autoCloseable : autoCloseables) {
            if (autoCloseable == null) continue;
            this.bind(autoCloseable);
        }
        return this;
    }

    @Override
    @Nonnull
    default public <T extends AutoCloseable> T bind(@Nonnull T terminable) {
        this.with(terminable);
        return terminable;
    }

    public void cleanup();
}

