/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text3.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.lucko.helper.text3.BlockNbtComponent;
import me.lucko.helper.text3.Component;
import me.lucko.helper.text3.event.ClickEvent;
import me.lucko.helper.text3.event.HoverEvent;
import me.lucko.helper.text3.format.Style;
import me.lucko.helper.text3.format.TextColor;
import me.lucko.helper.text3.format.TextDecoration;
import me.lucko.helper.text3.serializer.ComponentSerializer;
import me.lucko.helper.text3.serializer.gson.BlockNbtComponentPosSerializer;
import me.lucko.helper.text3.serializer.gson.ComponentSerializerImpl;
import me.lucko.helper.text3.serializer.gson.NameMapSerializer;
import me.lucko.helper.text3.serializer.gson.StyleSerializer;
import me.lucko.helper.text3.serializer.gson.TextColorWrapper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonComponentSerializer
implements ComponentSerializer<Component, Component, String>,
JsonDeserializer<Component>,
JsonSerializer<Component> {
    public static final GsonComponentSerializer INSTANCE = new GsonComponentSerializer();
    static final Gson GSON = GsonComponentSerializer.populate(new GsonBuilder()).create();

    public static @NonNull GsonBuilder populate(@NonNull GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(Component.class, (Object)ComponentSerializerImpl.INSTANCE).registerTypeAdapter(Style.class, (Object)StyleSerializer.INSTANCE).registerTypeAdapter(ClickEvent.Action.class, new NameMapSerializer<ClickEvent.Action>("click action", ClickEvent.Action.NAMES)).registerTypeAdapter(HoverEvent.Action.class, new NameMapSerializer<HoverEvent.Action>("hover action", HoverEvent.Action.NAMES)).registerTypeAdapter(TextColorWrapper.class, (Object)new TextColorWrapper.Serializer()).registerTypeAdapter(TextColor.class, new NameMapSerializer<TextColor>("text color", TextColor.NAMES)).registerTypeAdapter(TextDecoration.class, new NameMapSerializer<TextDecoration>("text decoration", TextDecoration.NAMES)).registerTypeHierarchyAdapter(BlockNbtComponent.Pos.class, (Object)BlockNbtComponentPosSerializer.INSTANCE);
        return builder;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String string) {
        return (Component)GSON.fromJson(string, Component.class);
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return GSON.toJson((Object)component);
    }

    @Deprecated
    public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return ComponentSerializerImpl.INSTANCE.deserialize(json, typeOfT, context);
    }

    @Deprecated
    public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
        return ComponentSerializerImpl.INSTANCE.serialize(src, typeOfSrc, context);
    }
}

