/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface LogEntry
extends Comparable<LogEntry> {
    public long getTimestamp();

    @Nonnull
    public UUID getActor();

    @Nonnull
    public String getActorName();

    @Nonnull
    public Type getType();

    @Nonnull
    public Optional<UUID> getActed();

    @Nonnull
    public String getActedName();

    @Nonnull
    public String getAction();

    public static interface Builder {
        @Nonnull
        public Builder setTimestamp(long var1);

        @Nonnull
        public Builder setActor(@Nonnull UUID var1);

        @Nonnull
        public Builder setActorName(@Nonnull String var1);

        @Nonnull
        public Builder setType(@Nonnull Type var1);

        @Nonnull
        public Builder setActed(@Nullable UUID var1);

        @Nonnull
        public Builder setActedName(@Nonnull String var1);

        @Nonnull
        public Builder setAction(@Nonnull String var1);

        @Nonnull
        public LogEntry build();
    }

    public static enum Type {
        USER('U'),
        GROUP('G'),
        TRACK('T');

        private final char code;

        private Type(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        @Nonnull
        public static Type valueOf(char code) {
            switch (code) {
                case 'U': 
                case 'u': {
                    return USER;
                }
                case 'G': 
                case 'g': {
                    return GROUP;
                }
                case 'T': 
                case 't': {
                    return TRACK;
                }
            }
            throw new IllegalArgumentException("Unknown code: " + code);
        }
    }
}

