/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.context.AbstractContextSet;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

public final class MutableContextSet
extends AbstractContextSet
implements ContextSet {
    private final SetMultimap<String, String> map;

    @Nonnull
    public static MutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        MutableContextSet set = MutableContextSet.create();
        set.add(key, value);
        return set;
    }

    @Nonnull
    public static MutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        Objects.requireNonNull(key1, "key1");
        Objects.requireNonNull(value1, "value1");
        Objects.requireNonNull(key2, "key2");
        Objects.requireNonNull(value2, "value2");
        MutableContextSet set = MutableContextSet.create();
        set.add(key1, value1);
        set.add(key2, value2);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        Objects.requireNonNull(iterable, "iterable");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(iterable);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromMap(@Nonnull Map<String, String> map) {
        Objects.requireNonNull(map, "map");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(map);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        Objects.requireNonNull(multimap, "multimap");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(multimap);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        Objects.requireNonNull(contextSet, "contextSet");
        if (contextSet instanceof ImmutableContextSet) {
            SetMultimap<String, String> map = ((ImmutableContextSet)contextSet).backing();
            return new MutableContextSet(map);
        }
        if (contextSet instanceof MutableContextSet) {
            return contextSet.mutableCopy();
        }
        MutableContextSet set = MutableContextSet.create();
        set.addAll(contextSet);
        return set;
    }

    @Nonnull
    public static MutableContextSet create() {
        return new MutableContextSet();
    }

    public MutableContextSet() {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    private MutableContextSet(SetMultimap<String, String> other) {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(other));
    }

    @Override
    protected SetMultimap<String, String> backing() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyTo(SetMultimap<String, String> other) {
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            other.putAll(this.map);
        }
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ImmutableContextSet makeImmutable() {
        if (this.map.isEmpty()) {
            return ImmutableContextSet.empty();
        }
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.copyOf(this.map));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MutableContextSet mutableCopy() {
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            return new MutableContextSet(this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> toSet() {
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            return ImmutableSet.copyOf((Collection)this.map.entries());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @Deprecated
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : this.map.entries()) {
                m.put(e.getKey(), e.getValue());
            }
        }
        return m.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Multimap<String, String> toMultimap() {
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            return ImmutableSetMultimap.copyOf(this.map);
        }
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.toSet().iterator();
    }

    @Override
    public Spliterator<Map.Entry<String, String>> spliterator() {
        return this.toSet().spliterator();
    }

    public void add(@Nonnull String key, @Nonnull String value) {
        this.map.put((Object)MutableContextSet.sanitizeKey(key), (Object)MutableContextSet.sanitizeValue(value));
    }

    public void add(@Nonnull Map.Entry<String, String> entry) {
        Objects.requireNonNull(entry, "entry");
        this.add(entry.getKey(), entry.getValue());
    }

    public void addAll(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        for (Map.Entry<String, String> entry : Objects.requireNonNull(iterable, "iterable")) {
            this.add(entry);
        }
    }

    public void addAll(@Nonnull Map<String, String> map) {
        this.addAll(Objects.requireNonNull(map, "map").entrySet());
    }

    public void addAll(@Nonnull Multimap<String, String> multimap) {
        this.addAll(Objects.requireNonNull(multimap, "multimap").entries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nonnull ContextSet contextSet) {
        Objects.requireNonNull(contextSet, "contextSet");
        if (contextSet instanceof AbstractContextSet) {
            AbstractContextSet other = (AbstractContextSet)contextSet;
            SetMultimap<String, String> setMultimap = this.map;
            synchronized (setMultimap) {
                other.copyTo(this.map);
            }
        } else {
            this.addAll(contextSet.toMultimap());
        }
    }

    public void remove(@Nonnull String key, @Nonnull String value) {
        this.map.remove((Object)MutableContextSet.sanitizeKey(key), (Object)MutableContextSet.sanitizeValue(value));
    }

    public void removeAll(@Nonnull String key) {
        this.map.removeAll((Object)MutableContextSet.sanitizeKey(key));
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return "MutableContextSet(contexts=" + this.map + ")";
    }
}

