/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.environment.loader;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public interface ScriptLoadingExecutor
extends Executor {
    public static ScriptLoadingExecutor usingJavaScheduler(final ScheduledExecutorService service) {
        Objects.requireNonNull(service, "service");
        return new ScriptLoadingExecutor(){

            @Override
            public AutoCloseable scheduleAtFixedRate(Runnable task, long time, TimeUnit unit) {
                ScheduledFuture<?> future = service.scheduleAtFixedRate(task, 0L, time, unit);
                return () -> future.cancel(false);
            }

            @Override
            public void execute(Runnable command) {
                service.execute(command);
            }
        };
    }

    public AutoCloseable scheduleAtFixedRate(Runnable var1, long var2, TimeUnit var4);
}

