/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.scriptcontroller.environment.registry;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.lucko.scriptcontroller.closable.CompositeAutoClosable;
import me.lucko.scriptcontroller.environment.registry.ScriptRegistry;
import me.lucko.scriptcontroller.environment.script.Script;

final class ScriptRegistryImpl
implements ScriptRegistry {
    private final Map<Path, Script> scripts = new HashMap<Path, Script>();

    ScriptRegistryImpl() {
    }

    @Override
    public void register(Script script) {
        this.scripts.put(script.getPath(), script);
    }

    @Override
    public void unregister(Script script) {
        this.scripts.remove(script.getPath());
    }

    @Override
    public Script getScript(Path path) {
        return this.scripts.get(path);
    }

    @Override
    public Map<Path, Script> getAll() {
        return Collections.unmodifiableMap(this.scripts);
    }

    @Override
    public void close() {
        CompositeAutoClosable.create().bindAll(this.scripts.values()).closeAndReportExceptions();
    }
}

