/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow.bukkit;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import me.lucko.shadow.Shadow;
import me.lucko.shadow.TargetResolver;
import me.lucko.shadow.bukkit.PackageVersion;
import org.checkerframework.checker.nullness.qual.NonNull;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface NmsClassTarget {
    public static final TargetResolver RESOLVER = new TargetResolver(){

        public @NonNull Optional<Class<?>> lookupClass(@NonNull Class<? extends Shadow> shadowClass) throws ClassNotFoundException {
            NmsClassTarget annotation = shadowClass.getAnnotation(NmsClassTarget.class);
            if (annotation == null) {
                return Optional.empty();
            }
            return Optional.of(PackageVersion.runtimeVersion().nmsClass(annotation.value()));
        }
    };

    public @NonNull String value();
}

