/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow.bukkit;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PackageVersion
extends Enum<PackageVersion> {
    public static final /* enum */ PackageVersion NONE;
    public static final /* enum */ PackageVersion v1_7_R1;
    public static final /* enum */ PackageVersion v1_7_R2;
    public static final /* enum */ PackageVersion v1_7_R3;
    public static final /* enum */ PackageVersion v1_7_R4;
    public static final /* enum */ PackageVersion v1_8_R1;
    public static final /* enum */ PackageVersion v1_8_R2;
    public static final /* enum */ PackageVersion v1_8_R3;
    public static final /* enum */ PackageVersion v1_9_R1;
    public static final /* enum */ PackageVersion v1_9_R2;
    public static final /* enum */ PackageVersion v1_10_R1;
    public static final /* enum */ PackageVersion v1_11_R1;
    public static final /* enum */ PackageVersion v1_12_R1;
    public static final /* enum */ PackageVersion v1_13_R1;
    public static final /* enum */ PackageVersion v1_13_R2;
    public static final /* enum */ PackageVersion v1_14_R1;
    public static final /* enum */ PackageVersion v1_15_R1;
    public static final /* enum */ PackageVersion v1_16_R1;
    public static final /* enum */ PackageVersion v1_16_R2;
    public static final /* enum */ PackageVersion v1_16_R3;
    public static final /* enum */ PackageVersion v1_17_R1;
    public static final String NMS = "net.minecraft.server";
    public static final String OBC = "org.bukkit.craftbukkit";
    private final @NonNull String nmsPrefix = "net.minecraft.server" + this.getPackageComponent();
    private final @NonNull String obcPrefix = "org.bukkit.craftbukkit" + this.getPackageComponent();
    private static final String RUNTIME_VERSION_STRING;
    private static final PackageVersion RUNTIME_VERSION;
    private static final /* synthetic */ PackageVersion[] $VALUES;

    public static PackageVersion[] values() {
        return (PackageVersion[])$VALUES.clone();
    }

    public static PackageVersion valueOf(String name) {
        return Enum.valueOf(PackageVersion.class, name);
    }

    protected @NonNull String getPackageComponent() {
        return "." + this.name() + ".";
    }

    public @NonNull String nms(@NonNull String className) {
        Objects.requireNonNull(className, "className");
        return this.nmsPrefix + className;
    }

    public @NonNull Class<?> nmsClass(@NonNull String className) throws ClassNotFoundException {
        return Class.forName(this.nms(className));
    }

    public @NonNull String obc(@NonNull String className) {
        Objects.requireNonNull(className, "className");
        return this.obcPrefix + className;
    }

    public @NonNull Class<?> obcClass(@NonNull String className) throws ClassNotFoundException {
        return Class.forName(this.obc(className));
    }

    private void checkComparable(PackageVersion other) {
        Objects.requireNonNull(other, "other");
        if (this == NONE) {
            throw new IllegalArgumentException("this cannot be NONE");
        }
        if (other == NONE) {
            throw new IllegalArgumentException("other cannot be NONE");
        }
    }

    public boolean isBefore(@NonNull PackageVersion other) {
        this.checkComparable(other);
        return this.ordinal() < other.ordinal();
    }

    public boolean isAfter(@NonNull PackageVersion other) {
        this.checkComparable(other);
        return this.ordinal() > other.ordinal();
    }

    public boolean isBeforeOrEq(@NonNull PackageVersion other) {
        this.checkComparable(other);
        return this.ordinal() <= other.ordinal();
    }

    public boolean isAfterOrEq(@NonNull PackageVersion other) {
        this.checkComparable(other);
        return this.ordinal() >= other.ordinal();
    }

    public static @NonNull PackageVersion runtimeVersion() {
        if (RUNTIME_VERSION == null) {
            throw new IllegalStateException("Unknown package version: " + RUNTIME_VERSION_STRING);
        }
        return RUNTIME_VERSION;
    }

    private static /* synthetic */ PackageVersion[] $values() {
        return new PackageVersion[]{NONE, v1_7_R1, v1_7_R2, v1_7_R3, v1_7_R4, v1_8_R1, v1_8_R2, v1_8_R3, v1_9_R1, v1_9_R2, v1_10_R1, v1_11_R1, v1_12_R1, v1_13_R1, v1_13_R2, v1_14_R1, v1_15_R1, v1_16_R1, v1_16_R2, v1_16_R3, v1_17_R1};
    }

    static {
        String obcPackage;
        NONE = new PackageVersion(){

            @Override
            protected @NonNull String getPackageComponent() {
                return ".";
            }
        };
        v1_7_R1 = new PackageVersion();
        v1_7_R2 = new PackageVersion();
        v1_7_R3 = new PackageVersion();
        v1_7_R4 = new PackageVersion();
        v1_8_R1 = new PackageVersion();
        v1_8_R2 = new PackageVersion();
        v1_8_R3 = new PackageVersion();
        v1_9_R1 = new PackageVersion();
        v1_9_R2 = new PackageVersion();
        v1_10_R1 = new PackageVersion();
        v1_11_R1 = new PackageVersion();
        v1_12_R1 = new PackageVersion();
        v1_13_R1 = new PackageVersion();
        v1_13_R2 = new PackageVersion();
        v1_14_R1 = new PackageVersion();
        v1_15_R1 = new PackageVersion();
        v1_16_R1 = new PackageVersion();
        v1_16_R2 = new PackageVersion();
        v1_16_R3 = new PackageVersion();
        v1_17_R1 = new PackageVersion();
        $VALUES = PackageVersion.$values();
        String serverVersion = "";
        Class<?> server = Bukkit.getServer().getClass();
        if (server.getSimpleName().equals("CraftServer") && !server.getName().equals("org.bukkit.craftbukkit.CraftServer") && (obcPackage = server.getPackage().getName()).startsWith("org.bukkit.craftbukkit.")) {
            serverVersion = obcPackage.substring("org.bukkit.craftbukkit.".length());
        }
        RUNTIME_VERSION_STRING = serverVersion;
        PackageVersion runtimeVersion = null;
        if (RUNTIME_VERSION_STRING.isEmpty()) {
            runtimeVersion = NONE;
        } else {
            try {
                runtimeVersion = PackageVersion.valueOf(serverVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        RUNTIME_VERSION = runtimeVersion;
    }
}

