/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Optional;
import me.lucko.shadow.Reflection;
import me.lucko.shadow.Shadow;
import me.lucko.shadow.TargetResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface DynamicMethodTarget {
    public static final TargetResolver RESOLVER = new TargetResolver(){

        @Override
        public @NonNull Optional<String> lookupMethod(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
            DynamicMethodTarget annotation = shadowMethod.getAnnotation(DynamicMethodTarget.class);
            if (annotation == null) {
                return Optional.empty();
            }
            return Optional.of(Reflection.getInstance(Function.class, annotation.value()).computeMethod(shadowMethod, shadowClass, targetClass));
        }
    };

    public @NonNull Class<? extends Function> value();

    @FunctionalInterface
    public static interface Function {
        public @NonNull String computeMethod(@NonNull Method var1, @NonNull Class<? extends Shadow> var2, @NonNull Class<?> var3);
    }
}

