/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.shadow;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import me.lucko.shadow.LoadingMap;
import me.lucko.shadow.Shadow;
import me.lucko.shadow.ShadowDefinition;
import me.lucko.shadow.ShadowInvocationHandler;
import me.lucko.shadow.ShadowingStrategy;
import me.lucko.shadow.TargetLookup;
import me.lucko.shadow.TargetResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ShadowFactory {
    private static final ShadowFactory INSTANCE = new ShadowFactory();
    private final @NonNull LoadingMap<Class<? extends Shadow>, ShadowDefinition> shadows = LoadingMap.of(this::initShadow);
    private final @NonNull TargetLookup targetLookup = new TargetLookup();

    public static ShadowFactory global() {
        return INSTANCE;
    }

    public final <T extends Shadow> @NonNull T shadow(@NonNull Class<T> shadowClass, @NonNull Object handle) {
        Objects.requireNonNull(shadowClass, "shadowClass");
        Objects.requireNonNull(handle, "handle");
        ShadowDefinition shadowDefinition = this.shadows.get(shadowClass);
        Class<?> targetClass = shadowDefinition.getTargetClass();
        if (!targetClass.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("Target class " + targetClass.getName() + " is not assignable from handle class " + handle.getClass().getName());
        }
        return (T)((Shadow)ShadowFactory.createProxy(shadowClass, new ShadowInvocationHandler(this, shadowDefinition, handle)));
    }

    public final <T extends Shadow> @NonNull T staticShadow(@NonNull Class<T> shadowClass) {
        Objects.requireNonNull(shadowClass, "shadowClass");
        ShadowDefinition shadowDefinition = this.shadows.get(shadowClass);
        return (T)((Shadow)ShadowFactory.createProxy(shadowClass, new ShadowInvocationHandler(this, shadowDefinition, null)));
    }

    public final <T extends Shadow> @NonNull T constructShadow(@NonNull Class<T> shadowClass, Object ... args) {
        return this.constructShadow(shadowClass, ShadowingStrategy.ForShadows.INSTANCE, args);
    }

    public final <T extends Shadow> @NonNull T constructShadow(@NonNull Class<T> shadowClass, @NonNull ShadowingStrategy.Unwrapper unwrapper, Object ... args) {
        Object newInstance;
        Object[] unwrappedArguments;
        Class<?>[] unwrappedParameterTypes;
        Objects.requireNonNull(shadowClass, "shadowClass");
        ShadowDefinition shadowDefinition = this.shadows.get(shadowClass);
        Class<?>[] argumentTypes = ShadowInvocationHandler.getArgumentTypes(args, null);
        try {
            unwrappedParameterTypes = unwrapper.unwrapAll(argumentTypes, this);
            unwrappedArguments = unwrapper.unwrapAll(args, unwrappedParameterTypes, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Class<?>[] unwrappedArgumentTypes = ShadowInvocationHandler.getArgumentTypes(unwrappedArguments, unwrappedParameterTypes);
        MethodHandle targetConstructor = shadowDefinition.findTargetConstructor(unwrappedArgumentTypes);
        try {
            newInstance = targetConstructor.invokeWithArguments(unwrappedArguments);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return this.shadow(shadowClass, newInstance);
    }

    public final void registerTargetResolver(@NonNull TargetResolver targetResolver) {
        this.targetLookup.registerResolver(targetResolver);
    }

    private @NonNull ShadowDefinition initShadow(@NonNull Class<? extends Shadow> shadowClass) {
        try {
            return new ShadowDefinition(this, shadowClass, this.targetLookup.lookupClass(shadowClass).orElseThrow(() -> new IllegalStateException("Shadow class " + shadowClass.getName() + " does not have a defined target class.")));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found for shadow " + shadowClass.getName(), e);
        }
    }

    @NonNull TargetLookup getTargetLookup() {
        return this.targetLookup;
    }

    @NonNull Class<?> getTargetClass(@NonNull Class<?> shadowClass) {
        ShadowDefinition definition = this.shadows.getIfPresent(shadowClass);
        return definition == null ? shadowClass : definition.getTargetClass();
    }

    private static <T> @NonNull T createProxy(@NonNull Class<T> interfaceType, @NonNull InvocationHandler handler) {
        ClassLoader classLoader = interfaceType.getClassLoader();
        return interfaceType.cast(Proxy.newProxyInstance(classLoader, new Class[]{interfaceType}, handler));
    }
}

