/*
 * Decompiled with CFR 0.152.
 */
package be.bendem.sqlstreams;

import be.bendem.sqlstreams.BatchUpdate;
import be.bendem.sqlstreams.Execute;
import be.bendem.sqlstreams.PreparedStatementBinderByIndex;
import be.bendem.sqlstreams.Query;
import be.bendem.sqlstreams.Transaction;
import be.bendem.sqlstreams.Update;
import be.bendem.sqlstreams.impl.SqlImpl;
import be.bendem.sqlstreams.util.Closeable;
import be.bendem.sqlstreams.util.SingleConnectionDataSource;
import be.bendem.sqlstreams.util.SqlFunction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Optional;
import javax.sql.DataSource;

public interface SqlStream
extends Closeable {
    public static SqlStream connect(Connection connection) {
        return SqlStream.connect(new SingleConnectionDataSource(connection));
    }

    public static SqlStream connect(DataSource dataSource) {
        return new SqlImpl(dataSource);
    }

    public <T> SqlStream registerCustomBinding(Class<T> var1, PreparedStatementBinderByIndex<T> var2);

    public Transaction transaction();

    public Transaction transaction(Transaction.IsolationLevel var1);

    public Query query(SqlFunction<Connection, PreparedStatement> var1);

    default public Query query(String sql) {
        return this.query((Connection conn) -> conn.prepareStatement(sql));
    }

    public Update update(SqlFunction<Connection, PreparedStatement> var1);

    default public Update update(String sql) {
        return this.update((Connection conn) -> conn.prepareStatement(sql));
    }

    public BatchUpdate batchUpdate(String var1);

    public Execute<PreparedStatement> execute(String var1);

    public Execute<CallableStatement> call(String var1);

    default public <R> Optional<R> first(String sql, SqlFunction<ResultSet, R> mapping, Object ... parameters) {
        try (Query query = (Query)this.query(sql).with(parameters);){
            Optional<R> optional = query.first(mapping);
            return optional;
        }
    }

    default public void exec(String sql, Object ... parameters) {
        try (Execute execute = (Execute)this.execute(sql).with(parameters);){
            execute.execute();
        }
    }

    @Override
    public void close();
}

