/*
 * Decompiled with CFR 0.152.
 */
package be.bendem.sqlstreams.impl;

import be.bendem.sqlstreams.BatchUpdate;
import be.bendem.sqlstreams.impl.ParameterProviderImpl;
import be.bendem.sqlstreams.impl.SqlImpl;
import be.bendem.sqlstreams.util.Wrap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

class BatchUpdateImpl
extends ParameterProviderImpl<BatchUpdate, PreparedStatement>
implements BatchUpdate {
    private final Connection connection;
    private final boolean closeConnection;

    BatchUpdateImpl(SqlImpl sql, Connection connection, PreparedStatement statement, boolean closeConnection) {
        super(statement, sql.bindings);
        this.connection = connection;
        this.closeConnection = closeConnection;
    }

    @Override
    public BatchUpdate next() {
        Wrap.execute(this.statement::addBatch);
        return this;
    }

    @Override
    public BatchUpdate next(String sql) {
        Wrap.execute(() -> this.statement.addBatch(sql));
        return this;
    }

    @Override
    public int[] counts() {
        return Wrap.get(this.statement::executeBatch);
    }

    @Override
    public long[] largeCounts() {
        return Wrap.get(this.statement::executeLargeBatch);
    }

    @Override
    public int count() {
        return IntStream.of(Wrap.get(this.statement::executeBatch)).sum();
    }

    @Override
    public long largeCount() {
        return LongStream.of(Wrap.get(this.statement::executeLargeBatch)).sum();
    }

    @Override
    public void close() {
        super.close();
        if (this.closeConnection) {
            Wrap.execute(this.connection::close);
        }
    }
}

