/*
 * Decompiled with CFR 0.152.
 */
package be.bendem.sqlstreams.impl;

import be.bendem.sqlstreams.BatchUpdate;
import be.bendem.sqlstreams.Execute;
import be.bendem.sqlstreams.PreparedStatementBinderByIndex;
import be.bendem.sqlstreams.Query;
import be.bendem.sqlstreams.SqlStream;
import be.bendem.sqlstreams.Transaction;
import be.bendem.sqlstreams.UncheckedSqlException;
import be.bendem.sqlstreams.Update;
import be.bendem.sqlstreams.impl.BatchUpdateImpl;
import be.bendem.sqlstreams.impl.ExecuteImpl;
import be.bendem.sqlstreams.impl.QueryImpl;
import be.bendem.sqlstreams.impl.SqlBindings;
import be.bendem.sqlstreams.impl.TransactionImpl;
import be.bendem.sqlstreams.impl.UpdateImpl;
import be.bendem.sqlstreams.util.SqlBiFunction;
import be.bendem.sqlstreams.util.SqlFunction;
import be.bendem.sqlstreams.util.Wrap;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;

public class SqlImpl
implements SqlStream {
    private final DataSource dataSource;
    final SqlBindings bindings;

    SqlImpl(SqlBindings bindings) {
        this.dataSource = null;
        this.bindings = bindings;
    }

    public SqlImpl(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
        this.bindings = new SqlBindings();
    }

    protected Connection getConnection() {
        return Wrap.get(this.dataSource::getConnection);
    }

    protected boolean closeConnectionAfterAction() {
        return true;
    }

    @Override
    public <T> SqlImpl registerCustomBinding(Class<T> clazz, PreparedStatementBinderByIndex<T> preparedStatementBinderByIndex) {
        this.bindings.addMapping(clazz, null, null, preparedStatementBinderByIndex);
        return this;
    }

    @Override
    public Transaction transaction() {
        return new TransactionImpl(this);
    }

    @Override
    public Transaction transaction(Transaction.IsolationLevel isolationLevel) {
        return new TransactionImpl(this, isolationLevel.isolationLevel);
    }

    @Override
    public Query query(SqlFunction<Connection, PreparedStatement> preparer) {
        return this.prepare(QueryImpl::new, preparer);
    }

    @Override
    public Update update(SqlFunction<Connection, PreparedStatement> preparer) {
        return this.prepare(UpdateImpl::new, preparer);
    }

    @Override
    public BatchUpdate batchUpdate(String sql) {
        return this.prepare(sql, BatchUpdateImpl::new, Connection::prepareStatement);
    }

    @Override
    public Execute<PreparedStatement> execute(String sql) {
        return this.prepare(sql, ExecuteImpl::new, Connection::prepareStatement);
    }

    @Override
    public Execute<CallableStatement> call(String sql) {
        return this.prepare(sql, ExecuteImpl::new, Connection::prepareCall);
    }

    @Override
    public void close() {
        if (this.dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            catch (SQLException e) {
                throw new UncheckedSqlException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <T, S extends Statement> T prepare(Creator<T, S> creator, SqlFunction<Connection, S> statementCreator) {
        Connection connection = this.getConnection();
        return creator.create(this, connection, Wrap.get(() -> (Statement)statementCreator.apply(connection)), this.closeConnectionAfterAction());
    }

    private <T, S extends Statement> T prepare(String sql, Creator<T, S> creator, SqlBiFunction<Connection, String, S> statementCreator) {
        Connection connection = this.getConnection();
        return creator.create(this, connection, Wrap.get(() -> (Statement)statementCreator.apply(connection, sql)), this.closeConnectionAfterAction());
    }

    @FunctionalInterface
    private static interface Creator<T, S extends Statement> {
        public T create(SqlImpl var1, Connection var2, S var3, boolean var4);
    }
}

