/*
 * Decompiled with CFR 0.152.
 */
package me.lyh.protobuf.generic;

import java.io.IOException;
import java.math.RoundingMode;
import java.util.Arrays;

public class Base64 {
    private static final Alphabet alphabet = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray());
    private static final char paddingChar = '=';
    private static final char ASCII_MAX = '\u007f';

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 0, byArray.length);
    }

    public static byte[] decode(CharSequence charSequence) {
        try {
            return Base64.decodeChecked(charSequence);
        }
        catch (DecodingException decodingException) {
            throw new IllegalArgumentException(decodingException);
        }
    }

    private static String encode(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(Base64.maxEncodedSize(n2));
        try {
            Base64.encodeTo(stringBuilder, byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    private static void encodeTo(Appendable appendable, byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; i += Base64.alphabet.bytesPerChunk) {
            Base64.encodeChunkTo(appendable, byArray, n + i, Math.min(Base64.alphabet.bytesPerChunk, n2 - i));
        }
    }

    private static void encodeChunkTo(Appendable appendable, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        long l = 0L;
        for (n4 = 0; n4 < n2; ++n4) {
            l |= (long)(byArray[n + n4] & 0xFF);
            l <<= 8;
        }
        n4 = (n2 + 1) * 8 - Base64.alphabet.bitsPerChar;
        for (n3 = 0; n3 < n2 * 8; n3 += Base64.alphabet.bitsPerChar) {
            int n5 = (int)(l >>> n4 - n3) & Base64.alphabet.mask;
            appendable.append(alphabet.encode(n5));
        }
        while (n3 < Base64.alphabet.bytesPerChunk * 8) {
            appendable.append('=');
            n3 += Base64.alphabet.bitsPerChar;
        }
    }

    private static byte[] decodeChecked(CharSequence charSequence) throws DecodingException {
        charSequence = Base64.trimTrailingFrom(charSequence);
        byte[] byArray = new byte[Base64.maxDecodedSize(charSequence.length())];
        int n = Base64.decodeTo(byArray, charSequence);
        return Base64.extract(byArray, n);
    }

    private static int decodeTo(byte[] byArray, CharSequence charSequence) throws DecodingException {
        if (!alphabet.isValidPaddingStartPosition((charSequence = Base64.trimTrailingFrom(charSequence)).length())) {
            throw new DecodingException("Invalid input length " + charSequence.length());
        }
        int n = 0;
        for (int i = 0; i < charSequence.length(); i += Base64.alphabet.charsPerChunk) {
            int n2;
            long l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < Base64.alphabet.charsPerChunk; ++n2) {
                l <<= Base64.alphabet.bitsPerChar;
                if (i + n2 >= charSequence.length()) continue;
                l |= (long)alphabet.decode(charSequence.charAt(i + n3++));
            }
            n2 = Base64.alphabet.bytesPerChunk * 8 - n3 * Base64.alphabet.bitsPerChar;
            for (int j = (Base64.alphabet.bytesPerChunk - 1) * 8; j >= n2; j -= 8) {
                byArray[n++] = (byte)(l >>> j & 0xFFL);
            }
        }
        return n;
    }

    private static int maxEncodedSize(int n) {
        return Base64.alphabet.charsPerChunk * Base64.divide(n, Base64.alphabet.bytesPerChunk, RoundingMode.CEILING);
    }

    private static int maxDecodedSize(int n) {
        return (int)(((long)Base64.alphabet.bitsPerChar * (long)n + 7L) / 8L);
    }

    private static byte[] extract(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static String trimTrailingFrom(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = n - 1; i >= 0; --i) {
            if (charSequence.charAt(i) == '=') continue;
            return charSequence.subSequence(0, i + 1).toString();
        }
        return "";
    }

    private static int divide(int n, int n2, RoundingMode roundingMode) {
        boolean bl;
        if (n2 == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int n3 = n / n2;
        int n4 = n - n2 * n3;
        if (n4 == 0) {
            return n3;
        }
        int n5 = 1 | (n ^ n2) >> 31;
        switch (roundingMode) {
            case UNNECESSARY: {
                throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
            }
            case DOWN: {
                bl = false;
                break;
            }
            case UP: {
                bl = true;
                break;
            }
            case CEILING: {
                bl = n5 > 0;
                break;
            }
            case FLOOR: {
                bl = n5 < 0;
                break;
            }
            case HALF_EVEN: 
            case HALF_DOWN: 
            case HALF_UP: {
                int n6 = Math.abs(n4);
                int n7 = n6 - (Math.abs(n2) - n6);
                if (n7 == 0) {
                    bl = roundingMode == RoundingMode.HALF_UP || roundingMode == RoundingMode.HALF_EVEN & (n3 & 1) != 0;
                    break;
                }
                bl = n7 > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return bl ? n3 + n5 : n3;
    }

    private static int log2(int n, RoundingMode roundingMode) {
        switch (roundingMode) {
            case UNNECESSARY: {
                if (n > 0 & (n & n - 1) != 0) {
                    throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
                }
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(n);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(n - 1);
            }
            case HALF_EVEN: 
            case HALF_DOWN: 
            case HALF_UP: {
                int n2 = Integer.numberOfLeadingZeros(n);
                int n3 = -1257966797 >>> n2;
                int n4 = 31 - n2;
                return n4 + (~(~(n3 - n)) >>> 31);
            }
        }
        throw new AssertionError();
    }

    private static final class Alphabet {
        private final char[] chars;
        final int mask;
        final int bitsPerChar;
        final int charsPerChunk;
        final int bytesPerChunk;
        private final byte[] decodabet;
        private final boolean[] validPadding;

        Alphabet(char[] cArray) {
            int n;
            this.chars = cArray;
            try {
                this.bitsPerChar = Base64.log2(cArray.length, RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Illegal alphabet length " + cArray.length, arithmeticException);
            }
            int n2 = Math.min(8, Integer.lowestOneBit(this.bitsPerChar));
            this.charsPerChunk = 8 / n2;
            this.bytesPerChunk = this.bitsPerChar / n2;
            this.mask = cArray.length - 1;
            byte[] byArray = new byte[128];
            Arrays.fill(byArray, (byte)-1);
            for (int i = 0; i < cArray.length; ++i) {
                n = cArray[i];
                byArray[n] = (byte)i;
            }
            this.decodabet = byArray;
            boolean[] blArray = new boolean[this.charsPerChunk];
            for (n = 0; n < this.bytesPerChunk; ++n) {
                blArray[Base64.divide((int)(n * 8), (int)this.bitsPerChar, (RoundingMode)RoundingMode.CEILING)] = true;
            }
            this.validPadding = blArray;
        }

        char encode(int n) {
            return this.chars[n];
        }

        boolean isValidPaddingStartPosition(int n) {
            return this.validPadding[n % this.charsPerChunk];
        }

        int decode(char c) throws DecodingException {
            if (c > '\u007f' || this.decodabet[c] == -1) {
                throw new DecodingException("Unrecognized character 0x" + Integer.toHexString(c));
            }
            return this.decodabet[c];
        }
    }

    private static final class DecodingException
    extends IOException {
        DecodingException(String string) {
            super(string);
        }
    }
}

