/*
 * Decompiled with CFR 0.152.
 */
package me.lyh.protobuf.generic;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.WireFormat;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import me.lyh.protobuf.generic.Base64;
import me.lyh.protobuf.generic.EnumSchema;
import me.lyh.protobuf.generic.Field;
import me.lyh.protobuf.generic.GenericReader$;
import me.lyh.protobuf.generic.Label;
import me.lyh.protobuf.generic.MessageSchema;
import me.lyh.protobuf.generic.Schema;
import me.lyh.protobuf.generic.Schema$;
import me.lyh.protobuf.generic.package$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uq!\u0002\t\u0012\u0011\u0003Qb!\u0002\u000f\u0012\u0011\u0003i\u0002\"B\u0014\u0002\t\u0003A\u0003\"B\u0015\u0002\t\u0003Q\u0003\"CA\u0007\u0003\u0005\u0005I\u0011BA\b\r\u0011a\u0012\u0003\u0001\u0017\t\u00115*!Q1A\u0005\u00029B\u0001BM\u0003\u0003\u0002\u0003\u0006Ia\f\u0005\u0006O\u0015!\ta\r\u0005\u0006k\u0015!\tA\u000e\u0005\u0006k\u0015!\tA\u0012\u0005\u0006k\u0015!\t\u0001\u0015\u0005\u0006k\u0015!I!\u0017\u0005\u0006S\u0016!IA\u001b\u0005\u0006k\u0016!IA\u001e\u0005\u0006}\u0016!Ia`\u0001\u000e\u000f\u0016tWM]5d%\u0016\fG-\u001a:\u000b\u0005I\u0019\u0012aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003)U\t\u0001\u0002\u001d:pi>\u0014WO\u001a\u0006\u0003-]\t1\u0001\\=i\u0015\u0005A\u0012AA7f\u0007\u0001\u0001\"aG\u0001\u000e\u0003E\u0011QbR3oKJL7MU3bI\u0016\u00148cA\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"aH\u0013\n\u0005\u0019\u0002#\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001\u001b\u0003\tyg\rF\u0002,\u0003\u0017\u0001\"aG\u0003\u0014\u0007\u0015qB%\u0001\u0004tG\",W.Y\u000b\u0002_A\u00111\u0004M\u0005\u0003cE\u0011aaU2iK6\f\u0017aB:dQ\u0016l\u0017\r\t\u000b\u0003WQBQ!\f\u0005A\u0002=\nAA]3bIR\u0011qG\u0010\t\u0003qmr!aG\u001d\n\u0005i\n\u0012a\u00029bG.\fw-Z\u0005\u0003yu\u0012QbR3oKJL7MU3d_J$'B\u0001\u001e\u0012\u0011\u0015y\u0014\u00021\u0001A\u0003\r\u0011WO\u001a\t\u0004?\u0005\u001b\u0015B\u0001\"!\u0005\u0015\t%O]1z!\tyB)\u0003\u0002FA\t!!)\u001f;f)\t9t\tC\u0003@\u0015\u0001\u0007\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u0006\u0019a.[8\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u000b\u0005f$XMQ;gM\u0016\u0014HCA\u001cR\u0011\u0015\u00116\u00021\u0001T\u0003\u0015Ig\u000e];u!\t!v+D\u0001V\u0015\t1F*\u0001\u0002j_&\u0011\u0001,\u0016\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eF\u000285\u0012DQA\u0015\u0007A\u0002m\u0003\"\u0001\u00182\u000e\u0003uS!\u0001\u00060\u000b\u0005}\u0003\u0017AB4p_\u001edWMC\u0001b\u0003\r\u0019w.\\\u0005\u0003Gv\u0013\u0001cQ8eK\u0012Le\u000e];u'R\u0014X-Y7\t\u000b\u0015d\u0001\u0019\u00014\u0002\u001b5,7o]1hKN\u001b\u0007.Z7b!\tYr-\u0003\u0002i#\tiQ*Z:tC\u001e,7k\u00195f[\u0006\f\u0011B]3bIZ\u000bG.^3\u0015\u0007-t\u0007\u000f\u0005\u0002 Y&\u0011Q\u000e\t\u0002\u0004\u0003:L\b\"B8\u000e\u0001\u0004Y\u0016AA5o\u0011\u0015\tX\u00021\u0001s\u0003\u00151\u0017.\u001a7e!\tY2/\u0003\u0002u#\t)a)[3mI\u0006Q!/Z1e\u001f\nTWm\u0019;\u0015\u0005]T\bCA\u0010y\u0013\tI\bE\u0001\u0003V]&$\b\"B8\u000f\u0001\u0004Y\bC\u0001+}\u0013\tiXKA\tPE*,7\r^%oaV$8\u000b\u001e:fC6\f1b\u001e:ji\u0016|%M[3diR\u0019q/!\u0001\t\u000f\u0005\rq\u00021\u0001\u0002\u0006\u0005\u0019q.\u001e;\u0011\u0007Q\u000b9!C\u0002\u0002\nU\u0013!c\u00142kK\u000e$x*\u001e;qkR\u001cFO]3b[\")Qf\u0001a\u0001_\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\u0002T\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001c\u0005U!AB(cU\u0016\u001cG\u000f")
public class GenericReader
implements scala.Serializable {
    private final Schema schema;

    public static GenericReader of(Schema schema) {
        return GenericReader$.MODULE$.of(schema);
    }

    public Schema schema() {
        return this.schema;
    }

    public Map<String, Object> read(byte[] buf) {
        return this.read(CodedInputStream.newInstance((byte[])buf), this.schema().root());
    }

    public Map<String, Object> read(ByteBuffer buf) {
        return this.read(CodedInputStream.newInstance((ByteBuffer)buf), this.schema().root());
    }

    public Map<String, Object> read(InputStream input) {
        return this.read(CodedInputStream.newInstance((InputStream)input), this.schema().root());
    }

    private Map<String, Object> read(CodedInputStream input, MessageSchema messageSchema) {
        TreeMap<Integer, Object> map = new TreeMap<Integer, Object>();
        while (!input.isAtEnd()) {
            Object object;
            int tag = input.readTag();
            int id = WireFormat.getTagFieldNumber((int)tag);
            Field field = (Field)messageSchema.fields().apply((Object)BoxesRunTime.boxToInteger((int)id));
            Label label = field.label();
            Label label2 = Label.REPEATED;
            if (!(label != null ? !((Object)((Object)label)).equals((Object)label2) : label2 != null)) {
                Object object2 = !map.containsKey(BoxesRunTime.boxToInteger((int)id)) ? map.put(Predef$.MODULE$.int2Integer(id), new ArrayList()) : BoxedUnit.UNIT;
                ArrayList list = (ArrayList)map.get(BoxesRunTime.boxToInteger((int)id));
                if (field.packed()) {
                    CodedInputStream bytesIn = CodedInputStream.newInstance((ByteBuffer)input.readByteBuffer());
                    while (!bytesIn.isAtEnd()) {
                        list.add(this.readValue(bytesIn, field));
                    }
                    object = BoxedUnit.UNIT;
                    continue;
                }
                object = BoxesRunTime.boxToBoolean((boolean)list.add(this.readValue(input, field)));
                continue;
            }
            object = map.put(Predef$.MODULE$.int2Integer(id), this.readValue(input, field));
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> result.put(((Field)messageSchema.fields().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)kv._1())))).name(), kv._2()));
        messageSchema.fields().valuesIterator().foreach((Function1 & Serializable & scala.Serializable)f -> f.default().isDefined() && !result.containsKey(f.name()) ? result.put(f.name(), f.default().get()) : BoxedUnit.UNIT);
        return result;
    }

    private Object readValue(CodedInputStream in, Field field) {
        Map<String, Object> map;
        Descriptors.FieldDescriptor.Type type = field.type();
        if (Descriptors.FieldDescriptor.Type.FLOAT.equals(type)) {
            map = BoxesRunTime.boxToFloat((float)in.readFloat());
        } else if (Descriptors.FieldDescriptor.Type.DOUBLE.equals(type)) {
            map = BoxesRunTime.boxToDouble((double)in.readDouble());
        } else if (Descriptors.FieldDescriptor.Type.FIXED32.equals(type)) {
            map = BoxesRunTime.boxToInteger((int)in.readFixed32());
        } else if (Descriptors.FieldDescriptor.Type.FIXED64.equals(type)) {
            map = BoxesRunTime.boxToLong((long)in.readFixed64());
        } else if (Descriptors.FieldDescriptor.Type.INT32.equals(type)) {
            map = BoxesRunTime.boxToInteger((int)in.readInt32());
        } else if (Descriptors.FieldDescriptor.Type.INT64.equals(type)) {
            map = BoxesRunTime.boxToLong((long)in.readInt64());
        } else if (Descriptors.FieldDescriptor.Type.UINT32.equals(type)) {
            map = BoxesRunTime.boxToInteger((int)in.readUInt32());
        } else if (Descriptors.FieldDescriptor.Type.UINT64.equals(type)) {
            map = BoxesRunTime.boxToLong((long)in.readUInt64());
        } else if (Descriptors.FieldDescriptor.Type.SFIXED32.equals(type)) {
            map = BoxesRunTime.boxToInteger((int)in.readSFixed32());
        } else if (Descriptors.FieldDescriptor.Type.SFIXED64.equals(type)) {
            map = BoxesRunTime.boxToLong((long)in.readSFixed64());
        } else if (Descriptors.FieldDescriptor.Type.SINT32.equals(type)) {
            map = BoxesRunTime.boxToInteger((int)in.readSInt32());
        } else if (Descriptors.FieldDescriptor.Type.SINT64.equals(type)) {
            map = BoxesRunTime.boxToLong((long)in.readSInt64());
        } else if (Descriptors.FieldDescriptor.Type.BOOL.equals(type)) {
            map = BoxesRunTime.boxToBoolean((boolean)in.readBool());
        } else if (Descriptors.FieldDescriptor.Type.STRING.equals(type)) {
            map = in.readString();
        } else if (Descriptors.FieldDescriptor.Type.BYTES.equals(type)) {
            map = Base64.encode(in.readByteArray());
        } else if (Descriptors.FieldDescriptor.Type.ENUM.equals(type)) {
            map = ((EnumSchema)this.schema().enums().apply(field.schema().get())).values().apply((Object)BoxesRunTime.boxToInteger((int)in.readEnum()));
        } else if (Descriptors.FieldDescriptor.Type.MESSAGE.equals(type)) {
            CodedInputStream nestedIn = CodedInputStream.newInstance((ByteBuffer)in.readByteBuffer());
            map = this.read(nestedIn, (MessageSchema)this.schema().messages().apply(field.schema().get()));
        } else {
            if (Descriptors.FieldDescriptor.Type.GROUP.equals(type)) {
                throw new IllegalArgumentException("Unsupported type: GROUP");
            }
            throw new MatchError((Object)type);
        }
        return map;
    }

    private void readObject(ObjectInputStream in) {
        Schema schema = Schema$.MODULE$.fromJson(in.readUTF());
        java.lang.reflect.Field schemaField = this.getClass().getDeclaredField("schema");
        schemaField.setAccessible(true);
        schemaField.set(this, schema);
    }

    private void writeObject(ObjectOutputStream out) {
        out.writeUTF(package$.MODULE$.JsonSchema(this.schema()).toJson());
    }

    public GenericReader(Schema schema) {
        this.schema = schema;
    }
}

