/*
 * Decompiled with CFR 0.152.
 */
package me.machinemaker.lectern;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.nio.file.Path;
import me.machinemaker.lectern.ConfigurationNode;
import me.machinemaker.lectern.contexts.InvalidKeyHandler;
import org.jetbrains.annotations.NotNull;

public final class YamlConfiguration
extends ConfigurationNode {
    private YamlConfiguration(@NotNull Path file, @NotNull ObjectMapper mapper, @NotNull InvalidKeyHandler invalidKeyHandler, char commentChar, int indentSize) {
        super(file, mapper, invalidKeyHandler, commentChar, indentSize);
    }

    @NotNull
    public static Builder builder(@NotNull Path path) {
        return new Builder(path);
    }

    public static final class Builder
    extends ConfigurationNode.TypedBuilder<YamlConfiguration, Builder> {
        private static final YAMLFactory YAML_FACTORY = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR);
        private ObjectMapper yamlMapper;
        private int indentSize = 2;

        private Builder(@NotNull Path file) {
            super(file);
        }

        public Builder withYamlMapper(ObjectMapper yamlMapper) {
            this.yamlMapper = yamlMapper;
            return this;
        }

        public Builder withIndentSize(int indentSize) {
            this.indentSize = indentSize;
            return this;
        }

        @NotNull
        public YamlConfiguration build() {
            ObjectMapper mapper = this.yamlMapper != null ? this.yamlMapper : new ObjectMapper((JsonFactory)YAML_FACTORY);
            return new YamlConfiguration(this.file(), mapper, this.invalidKeyHandler(), '#', this.indentSize);
        }
    }
}

