/*
 * Decompiled with CFR 0.152.
 */
package me.machinemaker.lectern.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import me.machinemaker.lectern.ConfigurationNode;
import me.machinemaker.lectern.YamlConfiguration;
import me.machinemaker.lectern.annotations.Configuration;
import me.machinemaker.lectern.contexts.InvalidKeyHandler;
import me.machinemaker.lectern.supplier.ConfigurationSupplier;
import org.jetbrains.annotations.NotNull;

@Documented
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Configuration(supplier=SimpleYamlConfigurationSupplier.class)
public @interface YamlConfig {
    public String fileName() default "config.yml";

    public int indent() default 2;

    public InvalidKeyHandler.Preset invalidKeyHandler() default InvalidKeyHandler.Preset.EXCEPTION;

    public static class SimpleYamlConfigurationSupplier
    implements ConfigurationSupplier<YamlConfig> {
        @NotNull
        public ConfigurationNode createConfiguration(@NotNull Path parentDir, @NotNull YamlConfig configuration) {
            return ((YamlConfiguration.Builder)YamlConfiguration.builder(parentDir.resolve(configuration.fileName())).withInvalidKeyHandler((InvalidKeyHandler)configuration.invalidKeyHandler())).withIndentSize(configuration.indent()).build();
        }
    }
}

