/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;
import java.util.ArrayList;
import java.util.List;
import me.majiajie.pagerbottomtabstrip.BottomLayoutController;
import me.majiajie.pagerbottomtabstrip.ItemController;
import me.majiajie.pagerbottomtabstrip.NavigationController;
import me.majiajie.pagerbottomtabstrip.R;
import me.majiajie.pagerbottomtabstrip.internal.CustomItemLayout;
import me.majiajie.pagerbottomtabstrip.internal.CustomItemVerticalLayout;
import me.majiajie.pagerbottomtabstrip.internal.MaterialItemLayout;
import me.majiajie.pagerbottomtabstrip.internal.MaterialItemVerticalLayout;
import me.majiajie.pagerbottomtabstrip.internal.Utils;
import me.majiajie.pagerbottomtabstrip.item.BaseTabItem;
import me.majiajie.pagerbottomtabstrip.item.MaterialItemView;
import me.majiajie.pagerbottomtabstrip.item.OnlyIconMaterialItemView;
import me.majiajie.pagerbottomtabstrip.listener.OnTabItemSelectedListener;

public class PageNavigationView
extends ViewGroup {
    private int mTabPaddingTop;
    private int mTabPaddingBottom;
    private NavigationController mNavigationController;
    private ViewPagerPageChangeListener mPageChangeListener;
    private ViewPager mViewPager;
    private boolean mEnableVerticalLayout;
    private OnTabItemSelectedListener mTabItemListener = new OnTabItemSelectedListener(){

        @Override
        public void onSelected(int index, int old) {
            if (PageNavigationView.this.mViewPager != null) {
                PageNavigationView.this.mViewPager.setCurrentItem(index, false);
            }
        }

        @Override
        public void onRepeat(int index) {
        }
    };
    private static final String INSTANCE_STATUS = "INSTANCE_STATUS";
    private final String STATUS_SELECTED = "STATUS_SELECTED";

    public PageNavigationView(Context context) {
        this(context, null);
    }

    public PageNavigationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PageNavigationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setPadding(0, 0, 0, 0);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PageNavigationView);
        if (a.hasValue(R.styleable.PageNavigationView_NavigationPaddingTop)) {
            this.mTabPaddingTop = a.getDimensionPixelSize(R.styleable.PageNavigationView_NavigationPaddingTop, 0);
        }
        if (a.hasValue(R.styleable.PageNavigationView_NavigationPaddingBottom)) {
            this.mTabPaddingBottom = a.getDimensionPixelSize(R.styleable.PageNavigationView_NavigationPaddingBottom, 0);
        }
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int maxHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
        }
        this.setMeasuredDimension(maxWidth, maxHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int width = r - l;
        int height = b - t;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.layout(0, 0, width, height);
        }
    }

    public CharSequence getAccessibilityClassName() {
        return PageNavigationView.class.getName();
    }

    public MaterialBuilder material() {
        return new MaterialBuilder();
    }

    public CustomBuilder custom() {
        return new CustomBuilder();
    }

    protected Parcelable onSaveInstanceState() {
        if (this.mNavigationController == null) {
            return super.onSaveInstanceState();
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATUS, super.onSaveInstanceState());
        bundle.putInt("STATUS_SELECTED", this.mNavigationController.getSelected());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            int selected = bundle.getInt("STATUS_SELECTED", 0);
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATUS));
            if (selected != 0 && this.mNavigationController != null) {
                this.mNavigationController.setSelect(selected);
            }
            return;
        }
        super.onRestoreInstanceState(state);
    }

    private class ViewPagerPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private ViewPagerPageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            if (PageNavigationView.this.mNavigationController != null && PageNavigationView.this.mNavigationController.getSelected() != position) {
                PageNavigationView.this.mNavigationController.setSelect(position);
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    private class Controller
    implements BottomLayoutController {
        private ObjectAnimator animator;
        private boolean hide = false;

        private Controller() {
        }

        @Override
        public void setupWithViewPager(ViewPager viewPager) {
            if (viewPager == null) {
                return;
            }
            PageNavigationView.this.mViewPager = viewPager;
            if (PageNavigationView.this.mPageChangeListener != null) {
                PageNavigationView.this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)PageNavigationView.this.mPageChangeListener);
            } else {
                PageNavigationView.this.mPageChangeListener = new ViewPagerPageChangeListener();
            }
            if (PageNavigationView.this.mNavigationController != null) {
                int n = PageNavigationView.this.mViewPager.getCurrentItem();
                if (PageNavigationView.this.mNavigationController.getSelected() != n) {
                    PageNavigationView.this.mNavigationController.setSelect(n);
                }
                PageNavigationView.this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)PageNavigationView.this.mPageChangeListener);
            }
        }

        @Override
        public void hideBottomLayout() {
            if (!this.hide) {
                this.hide = true;
                this.getAnimator().start();
            }
        }

        @Override
        public void showBottomLayout() {
            if (this.hide) {
                this.hide = false;
                this.getAnimator().reverse();
            }
        }

        private ObjectAnimator getAnimator() {
            if (this.animator == null) {
                this.animator = PageNavigationView.this.mEnableVerticalLayout ? ObjectAnimator.ofFloat((Object)((Object)PageNavigationView.this), (String)"translationX", (float[])new float[]{0.0f, -PageNavigationView.this.getWidth()}) : ObjectAnimator.ofFloat((Object)((Object)PageNavigationView.this), (String)"translationY", (float[])new float[]{0.0f, PageNavigationView.this.getHeight()});
                this.animator.setDuration(300L);
                this.animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            }
            return this.animator;
        }
    }

    private static class MaterialItemViewData {
        Drawable drawable;
        Drawable checkedDrawable;
        String title;
        @ColorInt
        int chekedColor;

        private MaterialItemViewData() {
        }
    }

    public class MaterialBuilder {
        private final int DEFAULT_COLOR = 0x56000000;
        private List<MaterialItemViewData> itemDatas = new ArrayList<MaterialItemViewData>();
        private int defaultColor;
        private int mode;
        private int messageBackgroundColor;
        private int messageNumberColor;
        private boolean enableVerticalLayout = false;
        private boolean doTintIcon = true;
        private boolean animateLayoutChanges = false;

        MaterialBuilder() {
        }

        @NonNull
        public NavigationController build() {
            ViewGroup itemController;
            PageNavigationView.this.mEnableVerticalLayout = this.enableVerticalLayout;
            if (this.itemDatas.isEmpty()) {
                throw new RuntimeException("must add a navigation item");
            }
            if (this.defaultColor == 0) {
                this.defaultColor = 0x56000000;
            }
            if (this.enableVerticalLayout) {
                ArrayList<BaseTabItem> items = new ArrayList<BaseTabItem>();
                for (MaterialItemViewData data : this.itemDatas) {
                    OnlyIconMaterialItemView materialItemView = new OnlyIconMaterialItemView(PageNavigationView.this.getContext());
                    materialItemView.initialization(data.title, data.drawable, data.checkedDrawable, this.doTintIcon, this.defaultColor, data.chekedColor);
                    if (this.messageBackgroundColor != 0) {
                        materialItemView.setMessageBackgroundColor(this.messageBackgroundColor);
                    }
                    if (this.messageNumberColor != 0) {
                        materialItemView.setMessageNumberColor(this.messageNumberColor);
                    }
                    items.add(materialItemView);
                }
                MaterialItemVerticalLayout materialItemVerticalLayout = new MaterialItemVerticalLayout(PageNavigationView.this.getContext());
                materialItemVerticalLayout.initialize(items, this.animateLayoutChanges, this.doTintIcon, this.defaultColor);
                materialItemVerticalLayout.setPadding(0, PageNavigationView.this.mTabPaddingTop, 0, PageNavigationView.this.mTabPaddingBottom);
                PageNavigationView.this.removeAllViews();
                PageNavigationView.this.addView((View)materialItemVerticalLayout);
                itemController = materialItemVerticalLayout;
            } else {
                boolean changeBackground = (this.mode & 2) > 0;
                ArrayList<MaterialItemView> items = new ArrayList<MaterialItemView>();
                ArrayList<Integer> checkedColors = new ArrayList<Integer>();
                for (MaterialItemViewData data : this.itemDatas) {
                    checkedColors.add(data.chekedColor);
                    MaterialItemView materialItemView = new MaterialItemView(PageNavigationView.this.getContext());
                    materialItemView.initialization(data.title, data.drawable, data.checkedDrawable, this.doTintIcon, this.defaultColor, changeBackground ? -1 : data.chekedColor);
                    if (this.messageBackgroundColor != 0) {
                        materialItemView.setMessageBackgroundColor(this.messageBackgroundColor);
                    }
                    if (this.messageNumberColor != 0) {
                        materialItemView.setMessageNumberColor(this.messageNumberColor);
                    }
                    items.add(materialItemView);
                }
                MaterialItemLayout materialItemLayout = new MaterialItemLayout(PageNavigationView.this.getContext());
                materialItemLayout.initialize(items, checkedColors, this.mode, this.animateLayoutChanges, this.doTintIcon, this.defaultColor);
                materialItemLayout.setPadding(0, PageNavigationView.this.mTabPaddingTop, 0, PageNavigationView.this.mTabPaddingBottom);
                PageNavigationView.this.removeAllViews();
                PageNavigationView.this.addView((View)materialItemLayout);
                itemController = materialItemLayout;
            }
            PageNavigationView.this.mNavigationController = new NavigationController(new Controller(), (ItemController)itemController);
            PageNavigationView.this.mNavigationController.addTabItemSelectedListener(PageNavigationView.this.mTabItemListener);
            return PageNavigationView.this.mNavigationController;
        }

        public MaterialBuilder addItem(@DrawableRes int drawableRes, @NonNull String title) {
            this.addItem(drawableRes, drawableRes, title, Utils.getColorPrimary(PageNavigationView.this.getContext()));
            return this;
        }

        public MaterialBuilder addItem(@DrawableRes int drawableRes, @DrawableRes int checkedDrawableRes, @NonNull String title) {
            this.addItem(drawableRes, checkedDrawableRes, title, Utils.getColorPrimary(PageNavigationView.this.getContext()));
            return this;
        }

        public MaterialBuilder addItem(@DrawableRes int drawableRes, @NonNull String title, @ColorInt int chekedColor) {
            this.addItem(drawableRes, drawableRes, title, chekedColor);
            return this;
        }

        public MaterialBuilder addItem(@DrawableRes int drawableRes, @DrawableRes int checkedDrawableRes, @NonNull String title, @ColorInt int chekedColor) {
            Drawable defaultDrawable = ContextCompat.getDrawable((Context)PageNavigationView.this.getContext(), (int)drawableRes);
            Drawable checkDrawable = ContextCompat.getDrawable((Context)PageNavigationView.this.getContext(), (int)checkedDrawableRes);
            if (defaultDrawable == null) {
                throw new Resources.NotFoundException("Resource ID " + Integer.toHexString(drawableRes));
            }
            if (checkDrawable == null) {
                throw new Resources.NotFoundException("Resource ID " + Integer.toHexString(checkedDrawableRes));
            }
            this.addItem(defaultDrawable, checkDrawable, title, chekedColor);
            return this;
        }

        public MaterialBuilder addItem(@NonNull Drawable drawable2, @NonNull String title) {
            this.addItem(drawable2, drawable2, title, Utils.getColorPrimary(PageNavigationView.this.getContext()));
            return this;
        }

        public MaterialBuilder addItem(@NonNull Drawable drawable2, @NonNull Drawable checkedDrawable, @NonNull String title) {
            this.addItem(drawable2, checkedDrawable, title, Utils.getColorPrimary(PageNavigationView.this.getContext()));
            return this;
        }

        public MaterialBuilder addItem(@NonNull Drawable drawable2, @NonNull String title, @ColorInt int chekedColor) {
            this.addItem(drawable2, drawable2, title, chekedColor);
            return this;
        }

        public MaterialBuilder addItem(@NonNull Drawable drawable2, @NonNull Drawable checkedDrawable, @NonNull String title, @ColorInt int chekedColor) {
            MaterialItemViewData data = new MaterialItemViewData();
            data.drawable = Utils.newDrawable(drawable2);
            data.checkedDrawable = Utils.newDrawable(checkedDrawable);
            data.title = title;
            data.chekedColor = chekedColor;
            this.itemDatas.add(data);
            return this;
        }

        public MaterialBuilder setDefaultColor(@ColorInt int color) {
            this.defaultColor = color;
            return this;
        }

        public MaterialBuilder setMessageBackgroundColor(@ColorInt int color) {
            this.messageBackgroundColor = color;
            return this;
        }

        public MaterialBuilder setMessageNumberColor(@ColorInt int color) {
            this.messageNumberColor = color;
            return this;
        }

        public MaterialBuilder setMode(int mode) {
            this.mode = mode;
            return this;
        }

        public MaterialBuilder enableVerticalLayout() {
            this.enableVerticalLayout = true;
            return this;
        }

        public MaterialBuilder dontTintIcon() {
            this.doTintIcon = false;
            return this;
        }

        public MaterialBuilder enableAnimateLayoutChanges() {
            this.animateLayoutChanges = true;
            return this;
        }
    }

    public class CustomBuilder {
        private List<BaseTabItem> items = new ArrayList<BaseTabItem>();
        private boolean enableVerticalLayout = false;
        private boolean animateLayoutChanges = false;

        CustomBuilder() {
        }

        public NavigationController build() {
            ViewGroup itemController;
            PageNavigationView.this.mEnableVerticalLayout = this.enableVerticalLayout;
            if (this.items.size() == 0) {
                throw new RuntimeException("must add a navigation item");
            }
            if (this.enableVerticalLayout) {
                CustomItemVerticalLayout verticalItemLayout = new CustomItemVerticalLayout(PageNavigationView.this.getContext());
                verticalItemLayout.initialize(this.items, this.animateLayoutChanges);
                verticalItemLayout.setPadding(0, PageNavigationView.this.mTabPaddingTop, 0, PageNavigationView.this.mTabPaddingBottom);
                PageNavigationView.this.removeAllViews();
                PageNavigationView.this.addView((View)verticalItemLayout);
                itemController = verticalItemLayout;
            } else {
                CustomItemLayout customItemLayout = new CustomItemLayout(PageNavigationView.this.getContext());
                customItemLayout.initialize(this.items, this.animateLayoutChanges);
                customItemLayout.setPadding(0, PageNavigationView.this.mTabPaddingTop, 0, PageNavigationView.this.mTabPaddingBottom);
                PageNavigationView.this.removeAllViews();
                PageNavigationView.this.addView((View)customItemLayout);
                itemController = customItemLayout;
            }
            PageNavigationView.this.mNavigationController = new NavigationController(new Controller(), (ItemController)itemController);
            PageNavigationView.this.mNavigationController.addTabItemSelectedListener(PageNavigationView.this.mTabItemListener);
            return PageNavigationView.this.mNavigationController;
        }

        public CustomBuilder addItem(BaseTabItem baseTabItem) {
            this.items.add(baseTabItem);
            return this;
        }

        public CustomBuilder enableVerticalLayout() {
            this.enableVerticalLayout = true;
            return this;
        }

        public CustomBuilder enableAnimateLayoutChanges() {
            this.animateLayoutChanges = true;
            return this;
        }
    }
}

