/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.LayoutTransition;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.core.view.ViewCompat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.majiajie.pagerbottomtabstrip.ItemController;
import me.majiajie.pagerbottomtabstrip.R;
import me.majiajie.pagerbottomtabstrip.item.BaseTabItem;
import me.majiajie.pagerbottomtabstrip.item.MaterialItemView;
import me.majiajie.pagerbottomtabstrip.listener.OnTabItemSelectedListener;
import me.majiajie.pagerbottomtabstrip.listener.SimpleTabItemSelectedListener;

public class MaterialItemLayout
extends ViewGroup
implements ItemController {
    private final int DEFAULT_SELECTED = 0;
    private final int MATERIAL_BOTTOM_NAVIGATION_ACTIVE_ITEM_MAX_WIDTH;
    private final int MATERIAL_BOTTOM_NAVIGATION_ITEM_MAX_WIDTH;
    private final int MATERIAL_BOTTOM_NAVIGATION_ITEM_MIN_WIDTH;
    private final int MATERIAL_BOTTOM_NAVIGATION_ITEM_HEIGHT;
    private final List<MaterialItemView> mItems = new ArrayList<MaterialItemView>();
    private final List<OnTabItemSelectedListener> mListeners = new ArrayList<OnTabItemSelectedListener>();
    private final List<SimpleTabItemSelectedListener> mSimpleListeners = new ArrayList<SimpleTabItemSelectedListener>();
    private boolean mItemTintIcon;
    private int mItemDefaultColor;
    private int[] mTempChildWidths;
    private int mItemTotalWidth;
    private int mSelected = -1;
    private int mOldSelected = -1;
    private boolean mHideTitle;
    private final int ANIM_TIME = 300;
    private Interpolator mInterpolator;
    private boolean mChangeBackgroundMode;
    private List<Integer> mBackgroundColors;
    private List<Oval> mOvals;
    private RectF mTempRectF;
    private Paint mPaint;
    private float mLastUpX;
    private float mLastUpY;

    public MaterialItemLayout(Context context) {
        this(context, null);
    }

    public MaterialItemLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialItemLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.MATERIAL_BOTTOM_NAVIGATION_ACTIVE_ITEM_MAX_WIDTH = res.getDimensionPixelSize(R.dimen.material_bottom_navigation_active_item_max_width);
        this.MATERIAL_BOTTOM_NAVIGATION_ITEM_MAX_WIDTH = res.getDimensionPixelSize(R.dimen.material_bottom_navigation_item_max_width);
        this.MATERIAL_BOTTOM_NAVIGATION_ITEM_MIN_WIDTH = res.getDimensionPixelSize(R.dimen.material_bottom_navigation_item_min_width);
        this.MATERIAL_BOTTOM_NAVIGATION_ITEM_HEIGHT = res.getDimensionPixelSize(R.dimen.material_bottom_navigation_height);
        this.mTempChildWidths = new int[5];
    }

    public void initialize(List<MaterialItemView> items, List<Integer> checkedColors, int mode, boolean animateLayoutChanges, boolean doTintIcon, int color) {
        if (animateLayoutChanges) {
            this.setLayoutTransition(new LayoutTransition());
        }
        this.mItems.clear();
        this.mItems.addAll(items);
        this.mItemTintIcon = doTintIcon;
        this.mItemDefaultColor = color;
        if ((mode & 2) > 0) {
            this.mChangeBackgroundMode = true;
            this.mOvals = new ArrayList<Oval>();
            this.mBackgroundColors = checkedColors;
            this.mInterpolator = new AccelerateDecelerateInterpolator();
            this.mTempRectF = new RectF();
            this.mPaint = new Paint();
            this.setBackgroundColor(this.mBackgroundColors.get(0));
        } else {
            for (int i = 0; i < this.mItems.size(); ++i) {
                MaterialItemView v = this.mItems.get(i);
                if (Build.VERSION.SDK_INT >= 21) {
                    v.setBackground((Drawable)new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{0xFFFFFF & checkedColors.get(i) | 0x56000000}), null, null));
                    continue;
                }
                v.setBackgroundResource(R.drawable.material_item_background);
            }
        }
        if ((mode & 1) > 0) {
            this.mHideTitle = true;
            for (MaterialItemView v : this.mItems) {
                v.setHideTitle(true);
            }
        }
        int n = this.mItems.size();
        for (int i = 0; i < n; ++i) {
            final MaterialItemView tabItem = this.mItems.get(i);
            tabItem.setChecked(false);
            this.addView((View)tabItem);
            tabItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int index = MaterialItemLayout.this.mItems.indexOf((Object)tabItem);
                    if (index >= 0) {
                        MaterialItemLayout.this.setSelect(index, MaterialItemLayout.this.mLastUpX, MaterialItemLayout.this.mLastUpY, true);
                    }
                }
            });
        }
        this.mSelected = 0;
        this.mItems.get(0).setChecked(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mItems == null || this.mItems.size() <= 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int count = this.getChildCount();
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.MATERIAL_BOTTOM_NAVIGATION_ITEM_HEIGHT, (int)0x40000000);
        if (this.mHideTitle) {
            int inactiveCount = count - 1;
            int activeMaxAvailable = width - inactiveCount * this.MATERIAL_BOTTOM_NAVIGATION_ITEM_MIN_WIDTH;
            int activeWidth = Math.min(activeMaxAvailable, this.MATERIAL_BOTTOM_NAVIGATION_ACTIVE_ITEM_MAX_WIDTH);
            int inactiveMaxAvailable = inactiveCount == 0 ? 0 : (width - activeWidth) / inactiveCount;
            int inactiveWidth = Math.min(inactiveMaxAvailable, this.MATERIAL_BOTTOM_NAVIGATION_ITEM_MAX_WIDTH);
            for (int i = 0; i < count; ++i) {
                this.mTempChildWidths[i] = i == this.mSelected ? (int)((float)(activeWidth - inactiveWidth) * this.mItems.get(this.mSelected).getAnimValue() + (float)inactiveWidth) : (i == this.mOldSelected ? (int)((float)activeWidth - (float)(activeWidth - inactiveWidth) * this.mItems.get(this.mSelected).getAnimValue()) : inactiveWidth);
            }
        } else {
            int maxAvailable = width / (count == 0 ? 1 : count);
            int childWidth = Math.min(maxAvailable, this.MATERIAL_BOTTOM_NAVIGATION_ACTIVE_ITEM_MAX_WIDTH);
            for (int i = 0; i < count; ++i) {
                this.mTempChildWidths[i] = childWidth;
            }
        }
        this.mItemTotalWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)this.mTempChildWidths[i], (int)0x40000000), heightSpec);
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = child.getMeasuredWidth();
            this.mItemTotalWidth += child.getMeasuredWidth();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int width = right - left;
        int height = bottom - top;
        int padding_top = this.getPaddingTop();
        int padding_bottom = this.getPaddingBottom();
        int used = 0;
        if (this.mItemTotalWidth > 0 && this.mItemTotalWidth < width) {
            used = (width - this.mItemTotalWidth) / 2;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                child.layout(width - used - child.getMeasuredWidth(), padding_top, width - used, height - padding_bottom);
            } else {
                child.layout(used, padding_top, child.getMeasuredWidth() + used, height - padding_bottom);
            }
            used += child.getMeasuredWidth();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mChangeBackgroundMode) {
            int width = this.getWidth();
            int height = this.getHeight();
            Iterator<Oval> iterator = this.mOvals.iterator();
            while (iterator.hasNext()) {
                Oval oval = iterator.next();
                this.mPaint.setColor(oval.color);
                if (oval.r < oval.maxR) {
                    this.mTempRectF.set(oval.getLeft(), oval.getTop(), oval.getRight(), oval.getBottom());
                    canvas.drawOval(this.mTempRectF, this.mPaint);
                } else {
                    this.setBackgroundColor(oval.color);
                    canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mPaint);
                    iterator.remove();
                }
                this.invalidate();
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1) {
            this.mLastUpX = ev.getX();
            this.mLastUpY = ev.getY();
        }
        return super.onInterceptTouchEvent(ev);
    }

    public CharSequence getAccessibilityClassName() {
        return MaterialItemLayout.class.getName();
    }

    @Override
    public void setSelect(int index) {
        this.setSelect(index, true);
    }

    @Override
    public void setSelect(int index, boolean needListener) {
        if (index >= this.mItems.size() || index < 0) {
            return;
        }
        View v = (View)this.mItems.get(index);
        this.setSelect(index, v.getX() + (float)v.getWidth() / 2.0f, v.getY() + (float)v.getHeight() / 2.0f, needListener);
    }

    @Override
    public void setMessageNumber(int index, int number) {
        this.mItems.get(index).setMessageNumber(number);
    }

    @Override
    public void setHasMessage(int index, boolean hasMessage) {
        this.mItems.get(index).setHasMessage(hasMessage);
    }

    @Override
    public void addTabItemSelectedListener(OnTabItemSelectedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void addSimpleTabItemSelectedListener(SimpleTabItemSelectedListener listener) {
        this.mSimpleListeners.add(listener);
    }

    @Override
    public void setTitle(int index, String title) {
        this.mItems.get(index).setTitle(title);
    }

    @Override
    public void setDefaultDrawable(int index, Drawable drawable2) {
        this.mItems.get(index).setDefaultDrawable(drawable2);
    }

    @Override
    public void setSelectedDrawable(int index, Drawable drawable2) {
        this.mItems.get(index).setSelectedDrawable(drawable2);
    }

    @Override
    public int getSelected() {
        return this.mSelected;
    }

    @Override
    public int getItemCount() {
        return this.mItems.size();
    }

    @Override
    public String getItemTitle(int index) {
        return this.mItems.get(index).getTitle();
    }

    @Override
    public boolean removeItem(int index) {
        if (index == this.mSelected || index >= this.mItems.size() || index < 0) {
            return false;
        }
        if (this.mSelected > index) {
            --this.mSelected;
        }
        this.removeViewAt(index);
        this.mItems.remove(index);
        if (this.mChangeBackgroundMode) {
            this.mBackgroundColors.remove(index);
        }
        return true;
    }

    @Override
    public void addMaterialItem(int index, Drawable defaultDrawable, Drawable selectedDrawable, String title, int selectedColor) {
        final MaterialItemView materialItemView = new MaterialItemView(this.getContext());
        materialItemView.initialization(title, defaultDrawable, selectedDrawable, this.mItemTintIcon, this.mItemDefaultColor, this.mChangeBackgroundMode ? -1 : selectedColor);
        materialItemView.setChecked(false);
        materialItemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int index = MaterialItemLayout.this.mItems.indexOf((Object)materialItemView);
                if (index >= 0) {
                    MaterialItemLayout.this.setSelect(index);
                }
            }
        });
        if (this.mHideTitle) {
            materialItemView.setHideTitle(true);
        }
        if (this.mSelected >= index) {
            ++this.mSelected;
        }
        if (index >= this.mItems.size()) {
            if (this.mChangeBackgroundMode) {
                this.mBackgroundColors.add(selectedColor);
            }
            this.mItems.add(materialItemView);
            this.addView((View)materialItemView);
        } else {
            if (this.mChangeBackgroundMode) {
                this.mBackgroundColors.add(index, selectedColor);
            }
            this.mItems.add(index, materialItemView);
            this.addView((View)materialItemView, index);
        }
    }

    @Override
    public void addCustomItem(int index, BaseTabItem item) {
    }

    private void setSelect(int index, float x, float y, boolean needListener) {
        if (index == this.mSelected) {
            if (needListener) {
                for (OnTabItemSelectedListener onTabItemSelectedListener : this.mListeners) {
                    onTabItemSelectedListener.onRepeat(this.mSelected);
                }
            }
            return;
        }
        this.mOldSelected = this.mSelected;
        this.mSelected = index;
        if (this.mChangeBackgroundMode) {
            this.addOvalColor(this.mBackgroundColors.get(this.mSelected), x, y);
        }
        if (this.mOldSelected >= 0) {
            this.mItems.get(this.mOldSelected).setChecked(false);
        }
        this.mItems.get(this.mSelected).setChecked(true);
        if (needListener) {
            for (OnTabItemSelectedListener onTabItemSelectedListener : this.mListeners) {
                onTabItemSelectedListener.onSelected(this.mSelected, this.mOldSelected);
            }
            for (SimpleTabItemSelectedListener simpleTabItemSelectedListener : this.mSimpleListeners) {
                simpleTabItemSelectedListener.onSelected(this.mSelected, this.mOldSelected);
            }
        }
    }

    private void addOvalColor(int color, float x, float y) {
        final Oval oval = new Oval(color, 2.0f, x, y);
        oval.maxR = this.getR(x, y);
        this.mOvals.add(oval);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{oval.r, oval.maxR});
        valueAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
        valueAnimator.setDuration(300L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                oval.r = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                MaterialItemLayout.this.invalidate();
            }
        });
        valueAnimator.start();
    }

    private float getR(float x, float y) {
        int width = this.getWidth();
        int height = this.getHeight();
        double r1_square = x * x + y * y;
        double r2_square = ((float)width - x) * ((float)width - x) + y * y;
        double r3_square = ((float)width - x) * ((float)width - x) + ((float)height - y) * ((float)height - y);
        double r4_square = x * x + ((float)height - y) * ((float)height - y);
        return (float)Math.sqrt(Math.max(Math.max(r1_square, r2_square), Math.max(r3_square, r4_square)));
    }

    private class Oval {
        int color;
        float r;
        float x;
        float y;
        float maxR;

        Oval(int color, float r, float x, float y) {
            this.color = color;
            this.r = r;
            this.x = x;
            this.y = y;
        }

        float getLeft() {
            return this.x - this.r;
        }

        float getTop() {
            return this.y - this.r;
        }

        float getRight() {
            return this.x + this.r;
        }

        float getBottom() {
            return this.y + this.r;
        }
    }
}

