/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip.internal;

import android.animation.LayoutTransition;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import me.majiajie.pagerbottomtabstrip.ItemController;
import me.majiajie.pagerbottomtabstrip.R;
import me.majiajie.pagerbottomtabstrip.item.BaseTabItem;
import me.majiajie.pagerbottomtabstrip.item.OnlyIconMaterialItemView;
import me.majiajie.pagerbottomtabstrip.listener.OnTabItemSelectedListener;
import me.majiajie.pagerbottomtabstrip.listener.SimpleTabItemSelectedListener;

public class MaterialItemVerticalLayout
extends ViewGroup
implements ItemController {
    private final int NAVIGATION_ITEM_SIZE;
    private final List<BaseTabItem> mItems = new ArrayList<BaseTabItem>();
    private final List<OnTabItemSelectedListener> mListeners = new ArrayList<OnTabItemSelectedListener>();
    private final List<SimpleTabItemSelectedListener> mSimpleListeners = new ArrayList<SimpleTabItemSelectedListener>();
    private int mSelected = -1;
    private boolean mItemTintIcon;
    private int mItemDefaultColor;

    public MaterialItemVerticalLayout(Context context) {
        this(context, null);
    }

    public MaterialItemVerticalLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialItemVerticalLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.NAVIGATION_ITEM_SIZE = this.getResources().getDimensionPixelSize(R.dimen.material_bottom_navigation_height);
    }

    public void initialize(List<BaseTabItem> items, boolean animateLayoutChanges, boolean doTintIcon, int color) {
        this.mItems.clear();
        this.mItems.addAll(items);
        this.mItemTintIcon = doTintIcon;
        this.mItemDefaultColor = color;
        if (animateLayoutChanges) {
            this.setLayoutTransition(new LayoutTransition());
        }
        int n = this.mItems.size();
        for (int i = 0; i < n; ++i) {
            final BaseTabItem tabItem = this.mItems.get(i);
            tabItem.setChecked(false);
            this.addView((View)tabItem);
            tabItem.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int index = MaterialItemVerticalLayout.this.mItems.indexOf((Object)tabItem);
                    if (index >= 0) {
                        MaterialItemVerticalLayout.this.setSelect(index);
                    }
                }
            });
        }
        this.mSelected = 0;
        this.mItems.get(0).setChecked(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = this.getChildCount();
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.NAVIGATION_ITEM_SIZE, (int)0x40000000);
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.NAVIGATION_ITEM_SIZE, (int)0x40000000);
        for (int i = 0; i < n; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(widthSpec, heightSpec);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int used = this.getPaddingTop();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.layout(0, used, child.getMeasuredWidth(), used + child.getMeasuredHeight());
            used += child.getMeasuredHeight();
        }
    }

    public CharSequence getAccessibilityClassName() {
        return MaterialItemVerticalLayout.class.getName();
    }

    @Override
    public void setSelect(int index) {
        this.setSelect(index, true);
    }

    @Override
    public void setSelect(int index, boolean needListener) {
        if (index == this.mSelected) {
            if (needListener) {
                for (OnTabItemSelectedListener listener : this.mListeners) {
                    listener.onRepeat(this.mSelected);
                }
            }
            return;
        }
        int oldSelected = this.mSelected;
        this.mSelected = index;
        if (oldSelected >= 0) {
            this.mItems.get(oldSelected).setChecked(false);
        }
        this.mItems.get(this.mSelected).setChecked(true);
        if (needListener) {
            for (OnTabItemSelectedListener onTabItemSelectedListener : this.mListeners) {
                onTabItemSelectedListener.onSelected(this.mSelected, oldSelected);
            }
            for (SimpleTabItemSelectedListener simpleTabItemSelectedListener : this.mSimpleListeners) {
                simpleTabItemSelectedListener.onSelected(this.mSelected, oldSelected);
            }
        }
    }

    @Override
    public void setMessageNumber(int index, int number) {
        this.mItems.get(index).setMessageNumber(number);
    }

    @Override
    public void setHasMessage(int index, boolean hasMessage) {
        this.mItems.get(index).setHasMessage(hasMessage);
    }

    @Override
    public void addTabItemSelectedListener(OnTabItemSelectedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void addSimpleTabItemSelectedListener(SimpleTabItemSelectedListener listener) {
        this.mSimpleListeners.add(listener);
    }

    @Override
    public void setTitle(int index, String title) {
        this.mItems.get(index).setTitle(title);
    }

    @Override
    public void setDefaultDrawable(int index, Drawable drawable2) {
        this.mItems.get(index).setDefaultDrawable(drawable2);
    }

    @Override
    public void setSelectedDrawable(int index, Drawable drawable2) {
        this.mItems.get(index).setSelectedDrawable(drawable2);
    }

    @Override
    public int getSelected() {
        return this.mSelected;
    }

    @Override
    public int getItemCount() {
        return this.mItems.size();
    }

    @Override
    public String getItemTitle(int index) {
        return this.mItems.get(index).getTitle();
    }

    @Override
    public boolean removeItem(int index) {
        if (index == this.mSelected || index >= this.mItems.size() || index < 0) {
            return false;
        }
        if (this.mSelected > index) {
            --this.mSelected;
        }
        this.removeViewAt(index);
        this.mItems.remove(index);
        return true;
    }

    @Override
    public void addMaterialItem(int index, Drawable defaultDrawable, Drawable selectedDrawable, String title, int selectedColor) {
        final OnlyIconMaterialItemView materialItemView = new OnlyIconMaterialItemView(this.getContext());
        materialItemView.initialization(title, defaultDrawable, selectedDrawable, this.mItemTintIcon, this.mItemDefaultColor, selectedColor);
        materialItemView.setChecked(false);
        materialItemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int index = MaterialItemVerticalLayout.this.mItems.indexOf((Object)materialItemView);
                if (index >= 0) {
                    MaterialItemVerticalLayout.this.setSelect(index);
                }
            }
        });
        if (index >= this.mItems.size()) {
            this.addView((View)materialItemView);
            this.mItems.add(materialItemView);
        } else {
            this.addView((View)materialItemView, index);
            this.mItems.add(index, materialItemView);
        }
    }

    @Override
    public void addCustomItem(int index, BaseTabItem item) {
    }
}

