/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip.internal;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import java.util.Locale;
import me.majiajie.pagerbottomtabstrip.R;
import me.majiajie.pagerbottomtabstrip.internal.Utils;

public class RoundMessageView
extends FrameLayout {
    private final View mOval;
    private final TextView mMessages;
    private int mMessageNumber;
    private boolean mHasMessage;

    public RoundMessageView(Context context) {
        this(context, null);
    }

    public RoundMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundMessageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.round_message_view, (ViewGroup)this, true);
        this.mOval = this.findViewById(R.id.oval);
        this.mMessages = (TextView)this.findViewById(R.id.msg);
        this.mMessages.setTypeface(Typeface.DEFAULT_BOLD);
        this.mMessages.setTextSize(1, 10.0f);
    }

    public void setMessageNumber(int number) {
        this.mMessageNumber = number;
        if (this.mMessageNumber > 0) {
            this.mOval.setVisibility(4);
            this.mMessages.setVisibility(0);
            if (this.mMessageNumber < 10) {
                this.mMessages.setTextSize(1, 12.0f);
            } else {
                this.mMessages.setTextSize(1, 10.0f);
            }
            if (this.mMessageNumber <= 99) {
                this.mMessages.setText((CharSequence)String.format(Locale.ENGLISH, "%d", this.mMessageNumber));
            } else {
                this.mMessages.setText((CharSequence)String.format(Locale.ENGLISH, "%d+", 99));
            }
        } else {
            this.mMessages.setVisibility(4);
            if (this.mHasMessage) {
                this.mOval.setVisibility(0);
            }
        }
    }

    public void setHasMessage(boolean hasMessage) {
        this.mHasMessage = hasMessage;
        if (hasMessage) {
            this.mOval.setVisibility(this.mMessageNumber > 0 ? 4 : 0);
        } else {
            this.mOval.setVisibility(4);
        }
    }

    public void tintMessageBackground(@ColorInt int color) {
        Drawable drawable2 = Utils.tinting(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.round), color);
        ViewCompat.setBackground((View)this.mOval, (Drawable)drawable2);
        ViewCompat.setBackground((View)this.mMessages, (Drawable)drawable2);
    }

    public void setMessageNumberColor(@ColorInt int color) {
        this.mMessages.setTextColor(color);
    }

    public int getMessageNumber() {
        return this.mMessageNumber;
    }

    public boolean hasMessage() {
        return this.mHasMessage;
    }
}

