/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;

public class Utils {
    public static Drawable tinting(Drawable drawable2, int color) {
        Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)drawable2);
        wrappedDrawable.mutate();
        DrawableCompat.setTint((Drawable)wrappedDrawable, (int)color);
        return wrappedDrawable;
    }

    public static Drawable newDrawable(Drawable drawable2) {
        Drawable.ConstantState constantState = drawable2.getConstantState();
        return constantState != null ? constantState.newDrawable() : drawable2;
    }

    public static int getColorPrimary(Context context) {
        Resources res = context.getResources();
        int attrRes = res.getIdentifier("colorPrimary", "attr", context.getPackageName());
        if (attrRes == 0) {
            return -16738680;
        }
        return ContextCompat.getColor((Context)context, (int)Utils.getResourceId(context, attrRes));
    }

    private static int getResourceId(Context context, int attrRes) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.resourceId;
    }
}

