/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip.item;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.majiajie.pagerbottomtabstrip.R;
import me.majiajie.pagerbottomtabstrip.internal.RoundMessageView;
import me.majiajie.pagerbottomtabstrip.internal.Utils;
import me.majiajie.pagerbottomtabstrip.item.BaseTabItem;

public class MaterialItemView
extends BaseTabItem {
    private final RoundMessageView mMessages;
    private final TextView mLabel;
    private final ImageView mIcon;
    private Drawable mDefaultDrawable;
    private Drawable mCheckedDrawable;
    private int mDefaultColor;
    private int mCheckedColor;
    private final float mTranslation;
    private final float mTranslationHideTitle;
    private final int mTopMargin;
    private final int mTopMarginHideTitle;
    private boolean mHideTitle;
    private boolean mChecked;
    private ValueAnimator mAnimator;
    private float mAnimatorValue = 1.0f;
    private boolean mIsMeasured = false;
    private boolean mTintIcon = true;

    public MaterialItemView(@NonNull Context context) {
        this(context, null);
    }

    public MaterialItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialItemView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        float scale = context.getResources().getDisplayMetrics().density;
        this.mTranslation = scale * 2.0f;
        this.mTranslationHideTitle = scale * 10.0f;
        this.mTopMargin = (int)(scale * 8.0f);
        this.mTopMarginHideTitle = (int)(scale * 16.0f);
        LayoutInflater.from((Context)context).inflate(R.layout.item_material, (ViewGroup)this, true);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mLabel = (TextView)this.findViewById(R.id.label);
        this.mMessages = (RoundMessageView)this.findViewById(R.id.messages);
    }

    public CharSequence getAccessibilityClassName() {
        return MaterialItemView.class.getName();
    }

    public void initialization(String title, Drawable drawable2, Drawable checkedDrawable, boolean tintIcon, int color, int checkedColor) {
        this.mTintIcon = tintIcon;
        this.mDefaultColor = color;
        this.mCheckedColor = checkedColor;
        if (this.mTintIcon) {
            this.mDefaultDrawable = Utils.tinting(drawable2, this.mDefaultColor);
            this.mCheckedDrawable = Utils.tinting(checkedDrawable, this.mCheckedColor);
        } else {
            this.mDefaultDrawable = drawable2;
            this.mCheckedDrawable = checkedDrawable;
        }
        this.mLabel.setText((CharSequence)title);
        this.mLabel.setTextColor(color);
        this.mIcon.setImageDrawable(this.mDefaultDrawable);
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        this.mAnimator.setDuration(115L);
        this.mAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MaterialItemView.this.mAnimatorValue = ((Float)animation.getAnimatedValue()).floatValue();
                if (MaterialItemView.this.mHideTitle) {
                    MaterialItemView.this.mIcon.setTranslationY(-MaterialItemView.this.mTranslationHideTitle * MaterialItemView.this.mAnimatorValue);
                } else {
                    MaterialItemView.this.mIcon.setTranslationY(-MaterialItemView.this.mTranslation * MaterialItemView.this.mAnimatorValue);
                }
                MaterialItemView.this.mLabel.setTextSize(2, 12.0f + MaterialItemView.this.mAnimatorValue * 2.0f);
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mIsMeasured = true;
    }

    @Override
    public void setChecked(boolean checked) {
        if (this.mChecked == checked) {
            return;
        }
        this.mChecked = checked;
        if (this.mHideTitle) {
            this.mLabel.setVisibility(this.mChecked ? 0 : 4);
        }
        if (this.mIsMeasured) {
            if (this.mChecked) {
                this.mAnimator.start();
            } else {
                this.mAnimator.reverse();
            }
        } else if (this.mChecked) {
            if (this.mHideTitle) {
                this.mIcon.setTranslationY(-this.mTranslationHideTitle);
            } else {
                this.mIcon.setTranslationY(-this.mTranslation);
            }
            this.mLabel.setTextSize(2, 14.0f);
        } else {
            this.mIcon.setTranslationY(0.0f);
            this.mLabel.setTextSize(2, 12.0f);
        }
        if (this.mChecked) {
            this.mIcon.setImageDrawable(this.mCheckedDrawable);
            this.mLabel.setTextColor(this.mCheckedColor);
        } else {
            this.mIcon.setImageDrawable(this.mDefaultDrawable);
            this.mLabel.setTextColor(this.mDefaultColor);
        }
    }

    @Override
    public void setMessageNumber(int number) {
        this.mMessages.setVisibility(0);
        this.mMessages.setMessageNumber(number);
    }

    @Override
    public void setHasMessage(boolean hasMessage) {
        this.mMessages.setVisibility(0);
        this.mMessages.setHasMessage(hasMessage);
    }

    @Override
    public void setTitle(String title) {
        this.mLabel.setText((CharSequence)title);
    }

    @Override
    public void setDefaultDrawable(Drawable drawable2) {
        this.mDefaultDrawable = this.mTintIcon ? Utils.tinting(drawable2, this.mDefaultColor) : drawable2;
        if (!this.mChecked) {
            this.mIcon.setImageDrawable(this.mDefaultDrawable);
        }
    }

    @Override
    public void setSelectedDrawable(Drawable drawable2) {
        this.mCheckedDrawable = this.mTintIcon ? Utils.tinting(drawable2, this.mCheckedColor) : drawable2;
        if (this.mChecked) {
            this.mIcon.setImageDrawable(this.mCheckedDrawable);
        }
    }

    @Override
    public String getTitle() {
        return this.mLabel.getText().toString();
    }

    public float getAnimValue() {
        return this.mAnimatorValue;
    }

    public void setHideTitle(boolean hideTitle) {
        this.mHideTitle = hideTitle;
        FrameLayout.LayoutParams iconParams = (FrameLayout.LayoutParams)this.mIcon.getLayoutParams();
        iconParams.topMargin = this.mHideTitle ? this.mTopMarginHideTitle : this.mTopMargin;
        this.mLabel.setVisibility(this.mChecked ? 0 : 4);
        this.mIcon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
    }

    public void setMessageBackgroundColor(@ColorInt int color) {
        this.mMessages.tintMessageBackground(color);
    }

    public void setMessageNumberColor(@ColorInt int color) {
        this.mMessages.setMessageNumberColor(color);
    }
}

