/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip.item;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import me.majiajie.pagerbottomtabstrip.R;
import me.majiajie.pagerbottomtabstrip.internal.RoundMessageView;
import me.majiajie.pagerbottomtabstrip.item.BaseTabItem;

public class NormalItemView
extends BaseTabItem {
    private ImageView mIcon;
    private final TextView mTitle;
    private final RoundMessageView mMessages;
    private Drawable mDefaultDrawable;
    private Drawable mCheckedDrawable;
    private int mDefaultTextColor = 0x56000000;
    private int mCheckedTextColor = 0x56000000;
    private boolean mChecked;

    public NormalItemView(Context context) {
        this(context, null);
    }

    public NormalItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NormalItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.item_normal, (ViewGroup)this, true);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mMessages = (RoundMessageView)this.findViewById(R.id.messages);
    }

    public CharSequence getAccessibilityClassName() {
        return NormalItemView.class.getName();
    }

    public void initialize(@DrawableRes int drawableRes, @DrawableRes int checkedDrawableRes, String title) {
        this.mDefaultDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)drawableRes);
        this.mCheckedDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)checkedDrawableRes);
        this.mTitle.setText((CharSequence)title);
    }

    @Override
    public void setChecked(boolean checked) {
        if (checked) {
            this.mIcon.setImageDrawable(this.mCheckedDrawable);
            this.mTitle.setTextColor(this.mCheckedTextColor);
        } else {
            this.mIcon.setImageDrawable(this.mDefaultDrawable);
            this.mTitle.setTextColor(this.mDefaultTextColor);
        }
        this.mChecked = checked;
    }

    @Override
    public void setMessageNumber(int number) {
        this.mMessages.setMessageNumber(number);
    }

    @Override
    public void setHasMessage(boolean hasMessage) {
        this.mMessages.setHasMessage(hasMessage);
    }

    @Override
    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    @Override
    public void setDefaultDrawable(Drawable drawable2) {
        this.mDefaultDrawable = drawable2;
        if (!this.mChecked) {
            this.mIcon.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setSelectedDrawable(Drawable drawable2) {
        this.mCheckedDrawable = drawable2;
        if (this.mChecked) {
            this.mIcon.setImageDrawable(drawable2);
        }
    }

    @Override
    public String getTitle() {
        return this.mTitle.getText().toString();
    }

    public void setTextDefaultColor(@ColorInt int color) {
        this.mDefaultTextColor = color;
    }

    public void setTextCheckedColor(@ColorInt int color) {
        this.mCheckedTextColor = color;
    }
}

