/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.pagerbottomtabstrip.item;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.majiajie.pagerbottomtabstrip.R;
import me.majiajie.pagerbottomtabstrip.internal.RoundMessageView;
import me.majiajie.pagerbottomtabstrip.internal.Utils;
import me.majiajie.pagerbottomtabstrip.item.BaseTabItem;

public class OnlyIconMaterialItemView
extends BaseTabItem {
    private final RoundMessageView mMessages;
    private final ImageView mIcon;
    private Drawable mDefaultDrawable;
    private Drawable mCheckedDrawable;
    private int mDefaultColor;
    private int mCheckedColor;
    private String mTitle;
    private boolean mChecked;
    private boolean mTintIcon = true;

    public OnlyIconMaterialItemView(@NonNull Context context) {
        this(context, null);
    }

    public OnlyIconMaterialItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OnlyIconMaterialItemView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.item_material_only_icon, (ViewGroup)this, true);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mMessages = (RoundMessageView)this.findViewById(R.id.messages);
    }

    public CharSequence getAccessibilityClassName() {
        return OnlyIconMaterialItemView.class.getName();
    }

    public void initialization(String title, Drawable drawable2, Drawable checkedDrawable, boolean tintIcon, int color, int checkedColor) {
        this.mTitle = title;
        this.mDefaultColor = color;
        this.mCheckedColor = checkedColor;
        this.mTintIcon = tintIcon;
        if (this.mTintIcon) {
            this.mDefaultDrawable = Utils.tinting(drawable2, this.mDefaultColor);
            this.mCheckedDrawable = Utils.tinting(checkedDrawable, this.mCheckedColor);
        } else {
            this.mDefaultDrawable = drawable2;
            this.mCheckedDrawable = checkedDrawable;
        }
        this.mIcon.setImageDrawable(this.mDefaultDrawable);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setBackground((Drawable)new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{0xFFFFFF & checkedColor | 0x56000000}), null, null));
        } else {
            this.setBackgroundResource(R.drawable.material_item_background);
        }
    }

    @Override
    public void setChecked(boolean checked) {
        if (this.mChecked == checked) {
            return;
        }
        this.mChecked = checked;
        if (this.mChecked) {
            this.mIcon.setImageDrawable(this.mCheckedDrawable);
        } else {
            this.mIcon.setImageDrawable(this.mDefaultDrawable);
        }
    }

    @Override
    public void setMessageNumber(int number) {
        this.mMessages.setVisibility(0);
        this.mMessages.setMessageNumber(number);
    }

    @Override
    public void setHasMessage(boolean hasMessage) {
        this.mMessages.setVisibility(0);
        this.mMessages.setHasMessage(hasMessage);
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setDefaultDrawable(Drawable drawable2) {
        this.mDefaultDrawable = this.mTintIcon ? Utils.tinting(drawable2, this.mDefaultColor) : drawable2;
        if (!this.mChecked) {
            this.mIcon.setImageDrawable(this.mDefaultDrawable);
        }
    }

    @Override
    public void setSelectedDrawable(Drawable drawable2) {
        this.mCheckedDrawable = this.mTintIcon ? Utils.tinting(drawable2, this.mCheckedColor) : drawable2;
        if (this.mChecked) {
            this.mIcon.setImageDrawable(this.mCheckedDrawable);
        }
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    public void setMessageBackgroundColor(@ColorInt int color) {
        this.mMessages.tintMessageBackground(color);
    }

    public void setMessageNumberColor(@ColorInt int color) {
        this.mMessages.setMessageNumberColor(color);
    }
}

