package me.matsumo.fankt.fanbox.datasource.db

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import me.matsumo.fankt.fanbox.domain.model.db.CookieEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
internal class CookieDao_Impl(
  __db: RoomDatabase,
) : CookieDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfCookieEntity: EntityInsertAdapter<CookieEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfCookieEntity = object : EntityInsertAdapter<CookieEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `fankt_cookies` (`id`,`domain`,`path`,`name`,`value`,`expiresAt`) VALUES (?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: CookieEntity) {
        statement.bindText(1, entity.id)
        statement.bindText(2, entity.domain)
        statement.bindText(3, entity.path)
        statement.bindText(4, entity.name)
        statement.bindText(5, entity.value)
        statement.bindLong(6, entity.expiresAt)
      }
    }
  }

  public override suspend fun insert(cookie: CookieEntity): Unit = performSuspending(__db, false,
      true) { _connection ->
    __insertAdapterOfCookieEntity.insert(_connection, cookie)
  }

  public override fun getAllCookies(): Flow<List<CookieEntity>> {
    val _sql: String = "SELECT * FROM fankt_cookies"
    return createFlow(__db, false, arrayOf("fankt_cookies")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _columnIndexOfDomain: Int = getColumnIndexOrThrow(_stmt, "domain")
        val _columnIndexOfPath: Int = getColumnIndexOrThrow(_stmt, "path")
        val _columnIndexOfName: Int = getColumnIndexOrThrow(_stmt, "name")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _columnIndexOfExpiresAt: Int = getColumnIndexOrThrow(_stmt, "expiresAt")
        val _result: MutableList<CookieEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: CookieEntity
          val _tmpId: String
          _tmpId = _stmt.getText(_columnIndexOfId)
          val _tmpDomain: String
          _tmpDomain = _stmt.getText(_columnIndexOfDomain)
          val _tmpPath: String
          _tmpPath = _stmt.getText(_columnIndexOfPath)
          val _tmpName: String
          _tmpName = _stmt.getText(_columnIndexOfName)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          val _tmpExpiresAt: Long
          _tmpExpiresAt = _stmt.getLong(_columnIndexOfExpiresAt)
          _item = CookieEntity(_tmpId,_tmpDomain,_tmpPath,_tmpName,_tmpValue,_tmpExpiresAt)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(id: String) {
    val _sql: String = "DELETE FROM fankt_cookies WHERE id = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, id)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun clear() {
    val _sql: String = "DELETE FROM fankt_cookies"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
