// Generated by Ktorfit
@file:Suppress("warnings")

package me.matsumo.fankt.fanbox.datasource

import de.jensklingenberg.ktorfit.Ktorfit
import de.jensklingenberg.ktorfit.`internal`.ClassProvider
import de.jensklingenberg.ktorfit.`internal`.InternalKtorfitApi
import de.jensklingenberg.ktorfit.`internal`.KtorfitConverterHelper
import de.jensklingenberg.ktorfit.converter.TypeData
import io.ktor.client.request.HttpRequestBuilder
import io.ktor.client.request.headers
import io.ktor.client.request.parameter
import io.ktor.client.request.setBody
import io.ktor.content.TextContent
import io.ktor.http.HttpMethod
import io.ktor.http.URLBuilder
import io.ktor.http.decodeURLQueryComponent
import io.ktor.http.takeFrom
import io.ktor.util.reflect.typeInfo
import kotlin.Int
import kotlin.OptIn
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import me.matsumo.fankt.fanbox.domain.entity.FanboxCreatorPostItemsEntity
import me.matsumo.fankt.fanbox.domain.entity.FanboxCreatorPostsPaginateEntity
import me.matsumo.fankt.fanbox.domain.entity.FanboxPostCommentListEntity
import me.matsumo.fankt.fanbox.domain.entity.FanboxPostDetailEntity
import me.matsumo.fankt.fanbox.domain.entity.FanboxPostListEntity
import me.matsumo.fankt.fanbox.domain.entity.FanboxPostSearchEntity

@OptIn(InternalKtorfitApi::class)
internal class _FanboxPostApiImpl(
  private val _ktorfit: Ktorfit,
) : FanboxPostApi {
  private val _helper: KtorfitConverterHelper = KtorfitConverterHelper(_ktorfit)

  override suspend fun getHomePosts(
    loadSize: String,
    maxPublishedDatetime: String?,
    maxId: String?,
  ): FanboxPostListEntity {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("GET")
        url{
        takeFrom(_ktorfit.baseUrl + "post.listHome")
        loadSize?.let{ parameter("limit", "$it") }
        maxPublishedDatetime?.let{ parameter("maxPublishedDatetime", "$it") }
        maxId?.let{ parameter("maxId", "$it") }
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<FanboxPostListEntity>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun getSupportedPosts(
    loadSize: String,
    maxPublishedDatetime: String?,
    maxId: String?,
  ): FanboxPostListEntity {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("GET")
        url{
        takeFrom(_ktorfit.baseUrl + "post.listSupporting")
        loadSize?.let{ parameter("limit", "$it") }
        maxPublishedDatetime?.let{ parameter("maxPublishedDatetime", "$it") }
        maxId?.let{ parameter("maxId", "$it") }
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<FanboxPostListEntity>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun getCreatorPosts(
    creatorId: String,
    loadSize: String,
    maxPublishedDatetime: String?,
    maxId: String?,
  ): FanboxCreatorPostItemsEntity {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("GET")
        url{
        takeFrom(_ktorfit.baseUrl + "post.listCreator")
        creatorId?.let{ parameter("creatorId", "$it") }
        loadSize?.let{ parameter("limit", "$it") }
        maxPublishedDatetime?.let{ parameter("maxPublishedDatetime", "$it") }
        maxId?.let{ parameter("maxId", "$it") }
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<FanboxCreatorPostItemsEntity>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun getCreatorPostsPagination(creatorId: String):
      FanboxCreatorPostsPaginateEntity {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("GET")
        url{
        takeFrom(_ktorfit.baseUrl + "post.paginateCreator")
        creatorId?.let{ parameter("creatorId", "$it") }
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<FanboxCreatorPostsPaginateEntity>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun getPostDetail(postId: String): FanboxPostDetailEntity {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("GET")
        url{
        takeFrom(_ktorfit.baseUrl + "post.info")
        postId?.let{ parameter("postId", "$it") }
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<FanboxPostDetailEntity>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun getPostComment(
    postId: String,
    offset: Int,
    loadSize: String,
  ): FanboxPostCommentListEntity {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("GET")
        url{
        takeFrom(_ktorfit.baseUrl + "post.listComments")
        postId?.let{ parameter("postId", "$it") }
        offset?.let{ parameter("offset", "$it") }
        loadSize?.let{ parameter("limit", "$it") }
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<FanboxPostCommentListEntity>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun getPostFromQuery(
    query: String,
    creatorId: String?,
    page: Int,
  ): FanboxPostSearchEntity {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("GET")
        url{
        takeFrom(_ktorfit.baseUrl + "post.listTagged")
        query?.let{ parameter("tag", "$it") }
        creatorId?.let{ parameter("creatorId", "$it") }
        page?.let{ parameter("page", "$it") }
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<FanboxPostSearchEntity>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun likePost(body: TextContent) {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("POST")
        url{
        takeFrom(_ktorfit.baseUrl + "post.likePost")
        }
        setBody(body)
        headers{
        append("Content-Type", "application/json")
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<Unit>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun likeComment(body: TextContent) {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("POST")
        url{
        takeFrom(_ktorfit.baseUrl + "post.likeComment")
        }
        setBody(body)
        headers{
        append("Content-Type", "application/json")
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<Unit>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun addComment(body: TextContent) {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("POST")
        url{
        takeFrom(_ktorfit.baseUrl + "post.addComment")
        }
        setBody(body)
        headers{
        append("Content-Type", "application/json")
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<Unit>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }

  override suspend fun deleteComment(body: TextContent) {
    val _ext: HttpRequestBuilder.() -> Unit = {
        method = HttpMethod.parse("POST")
        url{
        takeFrom(_ktorfit.baseUrl + "post.deleteComment")
        }
        setBody(body)
        headers{
        append("Content-Type", "application/json")
        } 
        }
    val _typeData = TypeData.createTypeData(
    typeInfo = typeInfo<Unit>(),
    )
    return _helper.suspendRequest(_typeData,_ext)!!
  }
}

internal class _FanboxPostApiProvider : ClassProvider<FanboxPostApi> {
  override fun create(_ktorfit: Ktorfit): FanboxPostApi = _FanboxPostApiImpl(_ktorfit)
}

internal fun Ktorfit.createFanboxPostApi(): FanboxPostApi = _FanboxPostApiImpl(this)
