/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.FutureImpl;
import me.melchor9000.net.IOService;
import me.melchor9000.net.NettyFuture;
import me.melchor9000.net.Procedure;
import me.melchor9000.net.Socket;
import me.melchor9000.net.SocketNotCreated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Acceptor<SocketType extends Socket>
implements AutoCloseable {
    protected final IOService service;
    protected Channel channel;
    protected ServerBootstrap bootstrap;
    protected Callback<SocketType> onConnection;

    Acceptor(@NotNull IOService service) {
        this.service = service;
        this.bootstrap = new ServerBootstrap().group(service.group);
    }

    Acceptor(@NotNull IOService serverService, @NotNull IOService workerService) {
        this.service = workerService;
        this.bootstrap = new ServerBootstrap().group(serverService.group, workerService.group);
    }

    @Override
    public void close() throws Exception {
        this.channel.close().sync();
    }

    @NotNull
    public Future<Void> closeAsync() {
        this.checkSocketCreated("closeAsync");
        return this.createFuture((io.netty.util.concurrent.Future)this.channel.close());
    }

    public void waitForClose() {
        this.checkSocketCreated("waitForClose");
        this.channel.closeFuture().syncUninterruptibly();
    }

    @NotNull
    public Future<Void> onClose() {
        this.checkSocketCreated("onClose");
        return this.createFuture((io.netty.util.concurrent.Future)this.channel.closeFuture());
    }

    public void bind(@NotNull SocketAddress address) throws InterruptedException {
        if (this.bootstrap != null) {
            this.channel = this.bootstrap.bind(address).sync().channel();
            this.bootstrap = null;
        } else {
            this.channel.bind(address).sync();
        }
    }

    public void bind(@NotNull InetAddress address, int port) throws InterruptedException {
        if (this.bootstrap != null) {
            this.channel = this.bootstrap.bind(address, port).sync().channel();
            this.bootstrap = null;
        } else {
            this.channel.bind((SocketAddress)new InetSocketAddress(address, port)).sync();
        }
    }

    public void bind(int port) throws InterruptedException {
        if (this.bootstrap != null) {
            this.channel = this.bootstrap.bind(port).sync().channel();
            this.bootstrap = null;
        } else {
            this.channel.bind((SocketAddress)new InetSocketAddress(port)).sync();
        }
    }

    @NotNull
    public abstract Future<SocketType> acceptAsync();

    @NotNull
    public SocketType accept() throws Exception {
        return (SocketType)((Socket)this.acceptAsync().sync().getValue());
    }

    public void setOnConnectionListener(@Nullable Callback<SocketType> cbk) {
        this.onConnection = cbk;
    }

    public <T> boolean setOption(@NotNull ChannelOption<T> option, @NotNull T value) {
        if (this.bootstrap == null) {
            return this.channel.config().setOption(option, value);
        }
        this.bootstrap.option(option, value);
        return true;
    }

    public <T> void setChildOption(@NotNull ChannelOption<T> option, @NotNull T value) {
        if (this.bootstrap == null) {
            throw new IllegalStateException("Cannot set child options when the server is listening");
        }
        this.bootstrap.option(option, value);
    }

    protected void checkSocketCreated(String method) {
        if (this.channel == null) {
            throw new SocketNotCreated("Cannot call " + method + " before creating the Socket", null);
        }
    }

    @NotNull
    protected <ReturnType> FutureImpl<ReturnType> createFuture(@NotNull Procedure whenCancelled) {
        return new FutureImpl(this.service, whenCancelled);
    }

    @NotNull
    protected <ReturnType> Future<ReturnType> createFuture(@NotNull io.netty.util.concurrent.Future<ReturnType> n) {
        return new NettyFuture<ReturnType>(n, this.service, null);
    }
}

