/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.TimeUnit;
import me.melchor9000.net.Future;
import me.melchor9000.net.NettyFuture;
import me.melchor9000.net.Procedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IOService {
    final EventLoopGroup group;

    public IOService() {
        this(1);
    }

    public IOService(int numberOfThreads) {
        this.group = new NioEventLoopGroup(numberOfThreads);
    }

    public void post(final @NotNull Procedure block) {
        this.group.submit(new Runnable(){

            @Override
            public void run() {
                block.call();
            }
        });
    }

    @NotNull
    public Future<?> schedule(final @NotNull Procedure block, long milliseconds) {
        return new NettyFuture(this.group.schedule(new Runnable(){

            @Override
            public void run() {
                block.call();
            }
        }, milliseconds, TimeUnit.MILLISECONDS), this);
    }

    public void cancel() {
        if (!this.group.isShutdown()) {
            this.group.shutdownGracefully().syncUninterruptibly();
        }
    }

    @Nullable
    public Future<?> cancelAsync() {
        if (!this.group.isShutdown()) {
            return new NettyFuture(this.group.shutdownGracefully(), this);
        }
        return null;
    }
}

