/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.channel.socket.SocketChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import me.melchor9000.net.IOService;
import me.melchor9000.net.SSLAcceptorConfigurator;
import me.melchor9000.net.SSLSocket;
import me.melchor9000.net.TCPAcceptor;
import me.melchor9000.net.TCPSocket;
import org.jetbrains.annotations.NotNull;

public class SSLAcceptor
extends TCPAcceptor {
    private File publicKeyFile;
    private File privateKeyFile;
    private InputStream publicKeyInputStream;
    private InputStream privateKeyInputStream;
    private String passwd;
    private SSLAcceptorConfigurator configurator;

    public SSLAcceptor(@NotNull IOService service, @NotNull File publicKey, @NotNull File privateKey) {
        this(service, publicKey, privateKey, null);
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull InputStream publicKey, @NotNull InputStream privateKey) {
        this(service, publicKey, privateKey, null);
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull File publicKey, @NotNull File privateKey, String password) {
        super(service);
        if (!publicKey.isFile()) {
            throw new IllegalArgumentException("publicKey must exist");
        }
        if (!privateKey.isFile()) {
            throw new IllegalArgumentException("privateKey must exist");
        }
        this.publicKeyFile = publicKey;
        this.privateKeyFile = privateKey;
        this.passwd = password;
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull InputStream publicKey, @NotNull InputStream privateKey, String password) {
        super(service);
        this.publicKeyInputStream = publicKey;
        this.privateKeyInputStream = privateKey;
        this.passwd = password;
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull IOService worker, @NotNull File publicKey, @NotNull File privateKey) {
        this(service, worker, publicKey, privateKey, null);
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull IOService worker, @NotNull InputStream publicKey, @NotNull InputStream privateKey) {
        this(service, worker, publicKey, privateKey, null);
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull IOService worker, @NotNull File publicKey, @NotNull File privateKey, String password) {
        super(service, worker);
        if (!publicKey.isFile()) {
            throw new IllegalArgumentException("publicKey must exist");
        }
        if (!privateKey.isFile()) {
            throw new IllegalArgumentException("privateKey must exist");
        }
        this.publicKeyFile = publicKey;
        this.privateKeyFile = privateKey;
        this.passwd = password;
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull IOService worker, @NotNull InputStream publicKey, @NotNull InputStream privateKey, String password) {
        super(service, worker);
        this.publicKeyInputStream = publicKey;
        this.privateKeyInputStream = privateKey;
        this.passwd = password;
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull SSLAcceptorConfigurator configurator) {
        super(service);
        this.configurator = configurator;
    }

    public SSLAcceptor(@NotNull IOService service, @NotNull IOService worker, @NotNull SSLAcceptorConfigurator configurator) {
        super(service, worker);
        this.configurator = configurator;
    }

    @Override
    @NotNull
    protected TCPSocket createSocketForImplementation(@NotNull SocketChannel ch) throws IOException {
        if (this.publicKeyFile != null) {
            return new SSLSocket(this, ch, this.publicKeyFile, this.privateKeyFile, this.passwd);
        }
        if (this.publicKeyInputStream != null) {
            return new SSLSocket(this, ch, this.publicKeyInputStream, this.privateKeyInputStream, this.passwd);
        }
        if (this.configurator != null) {
            return new SSLSocket(this, ch, this.configurator);
        }
        throw new IllegalStateException("Unreachable code, reached :(");
    }
}

