/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import io.netty.buffer.ByteBuf;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.resolver.DNSResourceData;
import org.jetbrains.annotations.NotNull;

public class DNSAAAA
extends DNSResourceData {
    private Inet6Address address;

    DNSAAAA(ByteBuf data) {
        super(data);
    }

    @NotNull
    public Inet6Address getAddress() {
        return this.address;
    }

    public void setAddress(@NotNull Inet6Address address) {
        this.address = address;
    }

    @Override
    public int byteBufSize() {
        return 16;
    }

    @Override
    public void toByteBuf(@NotNull ByteBuf buffer) {
        buffer.writeBytes(this.address.getAddress());
    }

    @Override
    public void fromByteBuf(@NotNull ByteBuf buffer) throws DataNotRepresentsObject {
        if (buffer.readableBytes() < 16) {
            throw new DataNotRepresentsObject("DNS RR type AAAA doesn't contain data", buffer);
        }
        byte[] addbin = new byte[this.byteBufSize()];
        buffer.readBytes(addbin);
        try {
            this.address = (Inet6Address)Inet6Address.getByAddress(addbin);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

