/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import io.netty.buffer.ByteBuf;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.resolver.DNSResourceData;
import me.melchor9000.net.resolver.DNSUtils;
import org.jetbrains.annotations.NotNull;

public class DNSMX
extends DNSResourceData {
    private int preference;
    private String exchange;

    public int getPreference() {
        return this.preference;
    }

    public void setPreference(int preference) {
        this.preference = preference;
    }

    @NotNull
    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(@NotNull String exchange) {
        this.exchange = exchange;
    }

    DNSMX(ByteBuf data) {
        super(data);
    }

    @Override
    public int byteBufSize() {
        return 4 + this.exchange.length();
    }

    @Override
    public void toByteBuf(@NotNull ByteBuf buffer) {
        buffer.writeShort(this.preference);
        DNSUtils.writeName(buffer, this.exchange);
    }

    @Override
    public void fromByteBuf(@NotNull ByteBuf buffer) throws DataNotRepresentsObject {
        if (buffer.readableBytes() < 2) {
            throw new DataNotRepresentsObject("DNS RR type MX doesn't contain data", buffer);
        }
        this.preference = buffer.readUnsignedShort();
        this.exchange = DNSUtils.readName(buffer);
    }

    public String toString() {
        return "(" + this.preference + ") " + this.exchange;
    }
}

