/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import io.netty.buffer.ByteBuf;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.Serializable;
import me.melchor9000.net.resolver.DNSUtils;
import org.jetbrains.annotations.NotNull;

public class DNSQuery
extends Serializable {
    private String name;
    private int type;
    private int mclass;

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeAsString() {
        return DNSUtils.typeToString(this.type);
    }

    public void setType(@NotNull String type) {
        this.type = DNSUtils.typeToInt(type);
    }

    public int getClass_() {
        return this.mclass;
    }

    public void setClass(int mclass) {
        this.mclass = mclass;
    }

    public String getClassAsString() {
        return DNSUtils.classToString(this.type);
    }

    public void setClass(@NotNull String type) {
        this.mclass = DNSUtils.classToInt(type);
    }

    @Override
    public int byteBufSize() {
        return this.name.length() + 6;
    }

    @Override
    public void toByteBuf(@NotNull ByteBuf buffer) {
        DNSUtils.writeName(buffer, this.name);
        buffer.writeShort(this.type);
        buffer.writeShort(this.mclass);
    }

    @Override
    public void fromByteBuf(@NotNull ByteBuf buffer) throws DataNotRepresentsObject {
        if (buffer.readableBytes() < 4) {
            throw new DataNotRepresentsObject("DNS Query is invalid", buffer);
        }
        this.name = DNSUtils.readName(buffer);
        this.type = buffer.readUnsignedShort();
        this.mclass = buffer.readUnsignedShort();
    }

    public String toString() {
        return "[" + DNSUtils.classToString(this.mclass) + "] " + DNSUtils.typeToString(this.type) + " " + this.name;
    }
}

